package clinical.web.vo;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import clinical.web.helpers.SubCorticalVarInfo;

/**
 * 
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectDerivedDataStats.java,v 1.5 2005/09/09 01:41:54 bozyurt
 *          Exp $
 */

public class SubjectDerivedDataStats {
	String subjectID;
	protected Map<String, DerivedVarStats> varStatInfoMap = new LinkedHashMap<String, DerivedVarStats>(17);

	public SubjectDerivedDataStats(String subjectID) {
		this.subjectID = subjectID;
	}

	public void addDerivedVarStats(DerivedVarStats dvs) {
		String key = "";
		if (dvs.getScVarInfo().getLaterality().trim().length() == 0
				|| dvs.getScVarInfo().getLaterality().trim().equalsIgnoreCase(
						"n/a")) {
			key = dvs.getScVarInfo().getBrainRegionName();
		} else {
			key = dvs.getScVarInfo().getLaterality() + "_"
					+ dvs.getScVarInfo().getBrainRegionName();
		}

		varStatInfoMap.put(key, dvs);
	}

	public DerivedVarStats getDerivedVarStats(String key) {
		return varStatInfoMap.get(key);
	}

	public Iterator<DerivedVarStats> iterator() {
		return varStatInfoMap.values().iterator();
	}

	public int getNumberOfVars() {
		return varStatInfoMap.size();
	}

	// ---------------------- setters --------------
	public void setSubjectID(String newSubjectID) {
		this.subjectID = newSubjectID;
	}

	// ---------------------- getters --------------
	public String getSubjectID() {
		return this.subjectID;
	}

	public static class DerivedVarStats {
		float max;
		float min;
		float avg;
		float std;
		SubCorticalVarInfo scVarInfo;
		float subjectValue;

		public DerivedVarStats(SubCorticalVarInfo scvi, float max, float min,
				float avg, float std, float subjectValue) {
			this.scVarInfo = scvi;
			this.max = max;
			this.min = min;
			this.avg = avg;
			this.std = std;
			this.subjectValue = subjectValue;
		}

		public DerivedVarStats(DerivedVarStats other) {
			this(other.scVarInfo, other.max, other.min, other.avg, other.std,
					other.subjectValue);
		}

		// ---------------------- setters --------------
		public void setMax(float newMax) {
			this.max = newMax;
		}

		public void setMin(float newMin) {
			this.min = newMin;
		}

		public void setAvg(float newAvg) {
			this.avg = newAvg;
		}

		public void setStd(float newStd) {
			this.std = newStd;
		}

		public void setScVarInfo(SubCorticalVarInfo newScVarInfo) {
			this.scVarInfo = newScVarInfo;
		}

		public void setSubjectValue(float newSubjectValue) {
			this.subjectValue = newSubjectValue;
		}

		// ---------------------- getters --------------
		public float getMax() {
			return this.max;
		}

		public float getMin() {
			return this.min;
		}

		public float getAvg() {
			return this.avg;
		}

		public float getStd() {
			return this.std;
		}

		public SubCorticalVarInfo getScVarInfo() {
			return this.scVarInfo;
		}

		public float getSubjectValue() {
			return this.subjectValue;
		}
	}

}