package clinical.web.vo.upload;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentType.java 810 2013-05-20 22:59:58Z bozyurt $
 */
public class AssessmentType implements Serializable {
	private static final long serialVersionUID = 1L;
	String name;
	String descr;
	List<ScoreType> siList = new ArrayList<ScoreType>();
	List<ScoreValue> svList = new ArrayList<ScoreValue>();

	public AssessmentType(String name, String descr) {
		super();
		this.name = name;
		this.descr = descr;
	}

	public String getName() {
		return name;
	}

	public String getDescr() {
		return descr;
	}

	public List<ScoreType> getSiList() {
		return siList;
	}

	public List<ScoreValue> getSvList() {
		return svList;
	}

	public void addScore(ScoreType si) {
		siList.add(si);
	}

	public void addValue(ScoreValue sv) {
		svList.add(sv);
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("name", name);
		js.put("descr", descr);
		JSONArray arr = new JSONArray();
		for (ScoreType si : siList) {
			arr.put(si.toJSON());
		}
		js.put("scores", arr);

		if (!svList.isEmpty()) {
			arr = new JSONArray();
			for (ScoreValue sv : svList) {
				arr.put(sv.toJSON());
			}
			js.put("values", arr);
		}
		return js;
	}

	public static AssessmentType initializeFromJSON(JSONObject js)
			throws JSONException {
		String name = js.getString("name");
		String descr = js.getString("descr");
		AssessmentType ai = new AssessmentType(name, descr);
		JSONArray arr = js.getJSONArray("scores");
		if (arr != null) {
			for (int i = 0; i < arr.length(); i++) {
				JSONObject json = arr.getJSONObject(i);
				ai.addScore(ScoreType.initializeFromJSON(json));
			}
		}
		if (js.has("values")) {
			arr = js.getJSONArray("values");
			if (arr != null) {
				for (int i = 0; i < arr.length(); i++) {
					JSONObject json = arr.getJSONObject(i);
					ai.addValue(ScoreValue.initializeFromJSON(json));
				}
			}
		}
		return ai;
	}

	@Override
	public String toString() {
		return "AssessmentType [name=" + name + ", descr=" + descr
				+ ",\n siList=" + siList + ",\n svList=" + svList + "]";
	}

}
