package clinical.web.vo.upload;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ScoreType.java 773 2013-03-02 00:14:00Z bozyurt $
 */
public class ScoreType implements Serializable {
	private static final long serialVersionUID = 1L;
	String name;
	String type;
	String descr;
	List<String> possibleValues;
	public final static String INT = "int";
	public final static String STRING = "string";
	public final static String FLOAT = "float";
	public static final String TIMESTAMP = "timestamp";

	public ScoreType(String name, String type, String descr,
			List<String> possibleValues) {
		super();
		this.name = name;
		this.type = type;
		this.descr = descr;
		this.possibleValues = possibleValues;
	}

	public String getName() {
		return name;
	}

	public String getType() {
		return type;
	}

	public List<String> getPossibleValues() {
		return possibleValues;
	}

	public void addPossibleValue(String value) {
		if (possibleValues == null) {
			possibleValues = new ArrayList<String>(5);
		}
		if (!possibleValues.contains(value))
			possibleValues.add(value);
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("name", name);
		js.put("type", type);
		js.put("descr", descr);
		JSONArray arr = new JSONArray();
		if (possibleValues != null && !possibleValues.isEmpty()) {
			for (String pv : possibleValues) {
				arr.put(pv);
			}
		}
		js.put("possibleValues", arr);

		return js;
	}

	public static ScoreType initializeFromJSON(JSONObject js)
			throws JSONException {
		String name = js.getString("name");
		String type = js.getString("type");
		String descr = js.getString("descr");
		List<String> possibleValues = new ArrayList<String>(5);
		ScoreType si = new ScoreType(name, type, descr, possibleValues);
		if (js.has("possibleValues")) {
			JSONArray arr = js.getJSONArray("possibleValues");
			if (arr != null) {
				for (int i = 0; i < arr.length(); i++) {
					String pv = arr.getString(i);
					si.addPossibleValue(pv);
				}
			}
		}
		return si;

	}

	public String getDescr() {
		return descr;
	}

	@Override
	public String toString() {
		return "ScoreType [name=" + name + ", type=" + type + "]";
	}
}
