package clinical.web.vo.upload;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ScoreValue.java 618 2012-05-23 01:29:09Z bozyurt $
 */
public class ScoreValue implements Serializable {
	private static final long serialVersionUID = 1L;
	String name;
	String value;

	public ScoreValue(String name, String value) {
		super();
		this.name = name;
		this.value = value;
	}

	public String getName() {
		return name;
	}

	public String getValue() {
		return value;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("name", name);
		js.put("value", value);
		return js;
	}

	public static ScoreValue initializeFromJSON(JSONObject js)
			throws JSONException {
		String name = js.getString("name");

		String value = null;
		if (js.has("value")) {
			value = js.getString("value");
		}
		return new ScoreValue(name, value);
	}

	@Override
	public String toString() {
		return "ScoreValue [name=" + name + ", value=" + value + "]";
	}
}
