package clinical.web.vo.upload;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SeriesHeaderInfo.java 794 2013-04-09 23:34:08Z bozyurt $
 */

public class SeriesHeaderInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	private String name;
	private String imageType;
	private String seriesType;
	private Date scanDate;
	private List<String> images = new ArrayList<String>(2);
	private String headerFile;
	List<HeaderFieldInfo> hfiList = new ArrayList<HeaderFieldInfo>(10);
	public final static String PFILE = "P-FILE";
	public final static String AFNI = "AFNI-BRIK";
	public final static String DICOM = "DICOM";
	public final static String ANALYZE = "ANALYZE";
	static SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm");

	public SeriesHeaderInfo() {}

	public SeriesHeaderInfo(String name, String imageType) {
		this.name = name;
		this.imageType = imageType;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getImageType() {
		return imageType;
	}

	public void setImageType(String imageType) {
		this.imageType = imageType;
	}

	public String getSeriesType() {
		return seriesType;
	}

	public void setSeriesType(String seriesType) {
		this.seriesType = seriesType;
	}

	public Date getScanDate() {
		return scanDate;
	}

	public void setScanDate(Date scanDate) {
		this.scanDate = scanDate;
	}

	public String getHeaderFile() {
		return headerFile;
	}

	public void setHeaderFile(String headerFile) {
		this.headerFile = headerFile;
	}

	public List<String> getImages() {
		return images;
	}

	public List<HeaderFieldInfo> getHfiList() {
		return hfiList;
	}

	public void setImages(List<String> images) {
		this.images = images;
	}

	public void addImage(String image) {
		images.add(image);
	}

	public void add(HeaderFieldInfo hfi) {
		hfiList.add(hfi);
	}

	
	public JSONObject toJSONNoImages() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("name", name);
		js.put("imageType", imageType);
		js.put("seriesType", seriesType);
		if (scanDate != null) {
			js.put("scanDate", sdf.format(scanDate));
		} else {
			js.put("scanDate", "");
		}
		JSONArray arr = new JSONArray();
		for (HeaderFieldInfo hfi : hfiList) {
			arr.put(hfi.toJSON());
		}
		js.put("hfiList", arr);
		return js;
	}
	
	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("name", name);
		js.put("imageType", imageType);
		js.put("seriesType", seriesType);
		if (scanDate != null) {
			js.put("scanDate", sdf.format(scanDate));
		} else {
			js.put("scanDate", "");
		}
		js.put("headerFile", headerFile);
		JSONArray arr = new JSONArray();
		for (HeaderFieldInfo hfi : hfiList) {
			arr.put(hfi.toJSON());
		}
		js.put("hfiList", arr);
		if (!images.isEmpty()) {
			arr = new JSONArray();
			for (String image : images) {
				JSONObject json = new JSONObject();
				json.put("img", image);
				arr.put(json);
			}
			js.put("images",arr);
		}
		return js;
	}

	public static SeriesHeaderInfo fromJSON(JSONObject js) throws JSONException,
			ParseException {
		String name = js.has("name") ? js.getString("name") : null;
		String imageType = js.getString("imageType");
		SeriesHeaderInfo shi = new SeriesHeaderInfo(name, imageType);
		shi.seriesType = js.has("seriesType") ? js.getString("seriesType") : null;
		shi.headerFile = js.has("headerFile") ? js.getString("headerFile") : null;
		String s = js.getString("scanDate");
		if (s.indexOf("/") != -1) {
			shi.scanDate = sdf.parse(s);
		}
		JSONArray arr = js.getJSONArray("hfiList");
		for (int i = 0; i < arr.length(); i++) {
			JSONObject child = arr.getJSONObject(i);
			HeaderFieldInfo hfi = HeaderFieldInfo.fromJSON(child);
			shi.add(hfi);
		}
		arr = js.getJSONArray("images");
		if (arr != null) {
			for (int i = 0; i < arr.length(); i++) {
				JSONObject child = arr.getJSONObject(i);
				shi.addImage(child.getString("img"));
			}
		}
		return shi;
	}
	
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("SeriesHeaderInfo::[");
		sb.append("images:[");
		for(String image : images) {
			sb.append(image);
			sb.append(',');
		}
		sb.append("] ");
		sb.append("]");
		return sb.toString();	
	}

}
