package clinical.web.workflow.cbf;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.CBFBIRNConstants;
import clinical.web.workflow.common.JSONUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: BrikInfo.java 504 2011-12-30 00:44:02Z bozyurt $
 */
public class BrikInfo implements Serializable, IFileInfo {
	private static final long serialVersionUID = 1L;
	private String brikName;
	private File headFile;
	private File brikFile;

	public BrikInfo(String brikName, File headFile, File brikFile) {
		super();
		this.brikName = brikName;
		this.headFile = headFile;
		this.brikFile = brikFile;
	}
	
	public BrikInfo(String brikName) {
		this.brikName = brikName;	
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("brikName", brikName);
		JSONUtils.addJSONField("headFile", headFile, js);
		JSONUtils.addJSONField("brikFile", brikFile, js);
		return js;
	}

	public static BrikInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		String brikName = js.getString("brikName");
		File headFile = JSONUtils.getFile("headFile", js);
		File brikFile = JSONUtils.getFile("brikFile", js);

		return new BrikInfo(brikName, headFile, brikFile);
	}

	public String getBrikName() {
		return brikName;
	}

	public void setBrikName(String brikName) {
		this.brikName = brikName;
	}

	public File getHeadFile() {
		return headFile;
	}

	public void setHeadFile(File headFile) {
		this.headFile = headFile;
	}

	public File getBrikFile() {
		return brikFile;
	}

	public void setBrikFile(File brikFile) {
		this.brikFile = brikFile;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((brikName == null) ? 0 : brikName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		BrikInfo other = (BrikInfo) obj;
		if (brikName == null) {
			if (other.brikName != null)
				return false;
		} else if (!brikName.equals(other.brikName))
			return false;
		return true;
	}

	@Override
	public String getBasename() {
		return brikName;
	}

	@Override
	public List<File> getFiles() {
        List<File> files = new ArrayList<File>(2);	
        files.add(this.headFile);
        files.add(this.brikFile);
		return files;
	}

	@Override
	public String getType() {
		return  CBFBIRNConstants.AFNI_TYPE;
	}

}
