package clinical.web.workflow.cbf;

import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.utils.Assertion;
import clinical.web.vo.upload.SegmentInfo;
import clinical.web.workflow.common.JSONUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: FieldMapInfo.java 512 2012-01-14 02:04:26Z bozyurt $
 */
public class FieldMapInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	File pfile;
	File fieldMap1DicomDir;
	File fieldMap2DicomDir;
	String prefix;
	File outputDir;
	SegmentInfo pfileSI;
	// generated output
	List<File> fmOutBrikFiles = new ArrayList<File>(2);
	List<File> outBrikFiles = new ArrayList<File>(2);

	public FieldMapInfo(File pfile, File fieldMap1DicomDir,
			File fieldMap2DicomDir, String prefix, File outputDir,
			SegmentInfo pfileSI) {
		super();
		this.pfile = pfile;
		this.fieldMap1DicomDir = fieldMap1DicomDir;
		this.fieldMap2DicomDir = fieldMap2DicomDir;
		this.prefix = prefix;
		this.outputDir = outputDir;
		this.pfileSI = pfileSI;
	}
	
	public void replaceFmOutFiles(File tcatFMOutBrikFile) {
		fmOutBrikFiles.clear();
		fmOutBrikFiles.add(tcatFMOutBrikFile);
		String headFileName = tcatFMOutBrikFile.getName();
		headFileName = headFileName.replaceFirst("\\.BRIK$", ".HEAD");
		File headFile = new File(tcatFMOutBrikFile.getParent(), headFileName);
		Assertion.assertTrue(headFile.isFile());
		fmOutBrikFiles.add(headFile);
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONUtils.addJSONField("pfile", pfile, js);
		JSONUtils.addJSONField("fieldMap1DicomDir", fieldMap1DicomDir, js);
		JSONUtils.addJSONField("fieldMap2DicomDir", fieldMap2DicomDir, js);
		if (prefix != null) {
			js.put("prefix", prefix);
		}
		JSONUtils.addJSONField("outputDir", outputDir, js);
		JSONUtils.addJSONSI("pfileSI", pfileSI, js);
		JSONUtils.addJSONArray("fmOutBrikFiles", fmOutBrikFiles, js);
		JSONUtils.addJSONArray("outBrikFiles", outBrikFiles, js);
		return js;
	}

	public static FieldMapInfo initializeFromJSON(JSONObject js)
			throws JSONException, ParseException {
		File pfile = JSONUtils.getFile("pfile", js);
		File fieldMap1DicomDir = JSONUtils.getFile("fieldMap1DicomDir", js);
		File fieldMap2DicomDir = JSONUtils.getFile("fieldMap2DicomDir", js);
		File outputDir = JSONUtils.getFile("outputDir", js);
		String prefix = null;
		if (js.has("prefix")) {
			prefix = js.getString("prefix");
		}
		SegmentInfo pfileSI = JSONUtils.getSI("pfileSI", js);

		FieldMapInfo fmi = new FieldMapInfo(pfile, fieldMap1DicomDir,
				fieldMap2DicomDir, prefix, outputDir, pfileSI);

		fmi.fmOutBrikFiles = JSONUtils.getFiles("fmOutBrikFiles", js);
		fmi.outBrikFiles = JSONUtils.getFiles("outBrikFiles", js);
		return fmi;
	}

	public File getPfile() {
		return pfile;
	}

	public String getPrefix() {
		return prefix;
	}

	public File getOutputDir() {
		return outputDir;
	}

	public SegmentInfo getPfileSI() {
		return pfileSI;
	}

	public void addFmOutBrikFile(File f) {
		fmOutBrikFiles.add(f);
	}

	public void addOutBrikFile(File f) {
		outBrikFiles.add(f);
	}

	public List<File> getFmOutBrikFiles() {
		return fmOutBrikFiles;
	}

	public File getFmOutBrikFile() {
		for (File f : fmOutBrikFiles) {
			if (f.getName().endsWith(".BRIK")) {
				return f;
			}
		}
		return null;
	}

	public List<File> getOutBrikFiles() {
		return outBrikFiles;
	}

	public File getFieldMap1DicomDir() {
		return fieldMap1DicomDir;
	}

	public File getFieldMap2DicomDir() {
		return fieldMap2DicomDir;
	}

	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("FieldMapInfo::[");
		sb.append("pfile:").append(pfile);
		sb.append(",prefix:").append(prefix);
		sb.append("]");
		return sb.toString();
	}

}
