package clinical.web.workflow.cbf;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.CBFBIRNConstants;

public class FileInfoFactory {

	public static IFileInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		if (js.has("type")) {
             String type = js.getString("type");
             if (type.equals(CBFBIRNConstants.AFNI_TYPE)) {
            	 return BrikInfo.initializeFromJSON(js);
             } else if (type.equals("file")) {
            	 return SingleFileInfo.initializeFromJSON(js);
             } else {
            	 throw new RuntimeException("Unsupported file info type:" + type);
             }
		} else {
			throw new RuntimeException("file info type cannot be determined!");
		}
	}
}
