package clinical.web.workflow.dti;

import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.vo.upload.SegmentInfo;
import clinical.web.workflow.common.JSONUtils;

public class DTIProcessInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	File outputDir;
	private SegmentInfo dtiSI;
	private SegmentInfo fieldMap1SI;
	private SegmentInfo fieldMap2SI;
	List<File> resultImageFiles = new ArrayList<File>(10);

	public DTIProcessInfo(SegmentInfo dtiSI, SegmentInfo fieldMap1SI,
			SegmentInfo fieldMap2SI, File outputDir) {
		this.dtiSI = dtiSI;
		this.fieldMap1SI = fieldMap1SI;
		this.fieldMap2SI = fieldMap2SI;
		this.outputDir = outputDir;
	}

	public List<File> getResultImageFiles() {
		return resultImageFiles;
	}

	public void addResultImage(File resultImg) {
		if (!this.resultImageFiles.contains(resultImg)) {
			this.resultImageFiles.add(resultImg);
		}
	}

	public File getOutputDir() {
		return outputDir;
	}

	public SegmentInfo getDtiSI() {
		return dtiSI;
	}

	public SegmentInfo getFieldMap1SI() {
		return fieldMap1SI;
	}

	public SegmentInfo getFieldMap2SI() {
		return fieldMap2SI;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONUtils.addJSONField("outputDir", outputDir, js);
		JSONUtils.addJSONSI("dtiSI", dtiSI, js);
		JSONUtils.addJSONSI("fieldMap1SI", fieldMap1SI, js);
		JSONUtils.addJSONSI("fieldMap2SI", fieldMap2SI, js);
		JSONUtils.addJSONArray("resultImageFiles", resultImageFiles, js);
		return js;
	}

	public static DTIProcessInfo initializeFromJSON(JSONObject js)
			throws JSONException, ParseException {
		File outputDir = JSONUtils.getFile("outputDir", js);
		SegmentInfo dtiSI = JSONUtils.getSI("dtiSI", js);
		SegmentInfo fieldMap1SI = JSONUtils.getSI("fieldMap1SI", js);
		SegmentInfo fieldMap2SI = JSONUtils.getSI("fieldMap2SI", js);

		DTIProcessInfo dpi = new DTIProcessInfo(dtiSI, fieldMap1SI,
				fieldMap2SI, outputDir);

		dpi.resultImageFiles = JSONUtils.getFiles("resultImageFiles", js);
		return dpi;
	}
}
