package clinical.web.workflow.dti;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DTIVisitProcessInfo.java 318 2011-01-13 23:06:38Z bozyurt $
 */
public class DTIVisitProcessInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	List<DTIProcessInfo> dpiList;

	public DTIVisitProcessInfo(List<DTIProcessInfo> dpiList) {
		super();
		this.dpiList = dpiList;
	}

	public List<DTIProcessInfo> getDpiList() {
		return dpiList;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONArray arr = new JSONArray();
		if (dpiList != null) {
			for (DTIProcessInfo dpi : dpiList) {
				arr.put(dpi.toJSON());
			}
		}
		js.put("dpiList", arr);

		return js;
	}

	public static DTIVisitProcessInfo initializeFromJSON(JSONObject js)
			throws JSONException, ParseException {
		JSONArray arr = js.getJSONArray("dpiList");
		List<DTIProcessInfo> dpiList = new ArrayList<DTIProcessInfo>(arr
				.length());
		for (int i = 0; i < arr.length(); i++) {
			DTIProcessInfo dpi = DTIProcessInfo.initializeFromJSON(arr
					.getJSONObject(i));
			dpiList.add(dpi);
		}
		DTIVisitProcessInfo dvpi = new DTIVisitProcessInfo(dpiList);
		return dvpi;
	}
}
