package clinical.ws.dataservices.client;

import java.net.URL;

import javax.xml.ws.BindingProvider;

import clinical.ws.BaseCLICLient;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: DataServicesCLIClient.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class DataServicesCLIClient extends BaseCLICLient {
	public DataServicesCLIClient() {
		super();
	}

	public String getExperiments(String webUser, String pwd) {
		DataServices ds = getDataServices();
		return ds.getExperiments(webUser, pwd);
	}

	public String getExperimentSubjects(String webUser, String pwd) {
		DataServices ds = getDataServices();
		return ds.getExperimentSubjects(webUser, pwd);
	}

	public String getSubjects4Experiment(String webUser, String pwd,
			String expName) {
		DataServices ds = getDataServices();
		return ds.getSubjects4Experiment(webUser, pwd, expName);
	}

	public String searchDD(String webUser, String pwd, String query) {
		DataServices ds = getDataServices();
		return ds.searchDD(webUser, pwd, query);
	}

	protected DataServices getDataServices() {
		URL wsdlURL = getClass().getClassLoader().getResource(
				"DataServices.wsdl");
		DataServicesClient client = new DataServicesClient(wsdlURL);
		DataServices port = client.getDataServicesImplPort();
		BindingProvider bp = (BindingProvider) port;
		String endPointAddress = getHostPort() + "/" + contextName
				+ "/services/DataServices";
		bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
				endPointAddress);
		System.out.println("EndPoint Address:"
				+ bp.getRequestContext().get(
						BindingProvider.ENDPOINT_ADDRESS_PROPERTY));
		if (useHTTPS) {
			prepForHTTPS(port);
		}
		return port;
	}

	public static void main(String[] args) {
		DataServicesCLIClient client = new DataServicesCLIClient();

		String s = client.getExperiments("b", "b");
		System.out.println(s);
	}

}
