package clinical.xml;

import java.io.IOException;

import javax.jws.WebService;

import clinical.xml.export.XCEDEFault;

/**
 * @author I. Burak Ozyurt
 * @version $Id: XCatalogServiceImpl.java,v 1.2 2008/08/26 00:08:01 bozyurt Exp
 *          $
 */
@WebService(endpointInterface = "clinical.xml.XCatalogService", serviceName = "XCatalogService", portName = "xcatalogServicePort")
public class XCatalogServiceImpl implements XCatalogService {

   public String getCatalogForSubject(String webUser, String pwd,
         String siteID, String experimentID, String subjectID, String visitID)
         throws XCEDEFault {
      String dbID = null;
      try {
         dbID = getDBID();

         ApplicationUtils.authenticate(webUser, pwd, dbID);
         String result = "<XCEDE/>";
         // TODO
         return result;
      } catch (Exception x) {
         x.printStackTrace();
         throw new XCEDEFault(x.getMessage());
      }

   }

   public String getSubjectsWithDerivedData(String webUser, String pwd,
         String derivedDataType) throws XCEDEFault {
      String dbID = null;
      try {
         dbID = getDBID();
         ApplicationUtils.authenticate(webUser, pwd, dbID);
         // TODO
         String result = "<XCEDE/>";
         return result;
      } catch (Exception x) {
         x.printStackTrace();
         throw new XCEDEFault(x.getMessage());
      }
   }

   protected String getDBID() throws IOException, Exception {
      String dbID;
      dbID = ApplicationUtils.getProperty("fbirn.dbid");
      if (dbID == null) {
         throw new Exception(
               "Cannot detect data source! Possible misconfiguration!");
      }
      return dbID;
   }

}
