package clinical.xml.export;

import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.server.VisitInfo;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Experiment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.Subjexperiment;
import clinical.utils.GenUtils;
import clinical.web.IExperimentManagement;
import clinical.web.ISubjectAssessmentManagement;
import clinical.web.ISubjectVisitHandler;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.common.query.SearchCriteria;
import clinical.web.common.query.SearchPredicateList;
import clinical.web.common.security.DBConfig;
import clinical.web.exception.SubjectVisitManagementException;
import clinical.web.services.DBPoolService;
import clinical.web.services.SimpleSecurityService;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.vo.ScoreValue;
import clinical.web.vo.Study;
import clinical.web.vo.StudySegment;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;
import clinical.xml.ApplicationUtils;
import clinical.xml.XMLUtils;
import clinical.xml.xcede.Assessment;
import clinical.xml.xcede.AssessmentValue;
import clinical.xml.xcede.Datarec;
import clinical.xml.xcede.Datarec_g;
import clinical.xml.xcede.ExpProtocol;
import clinical.xml.xcede.ExpProtocol_g;
import clinical.xml.xcede.ProjectData_g;
import clinical.xml.xcede.ProjectRef;
import clinical.xml.xcede.Projectlevel;
import clinical.xml.xcede.Projectlevel_g;
import clinical.xml.xcede.Scanner;
import clinical.xml.xcede.Scanner_g;
import clinical.xml.xcede.Series;
import clinical.xml.xcede.SeriesData_g;
import clinical.xml.xcede.Serieslevel;
import clinical.xml.xcede.Serieslevel_g;
import clinical.xml.xcede.StudyData_g;
import clinical.xml.xcede.StudyRef;
import clinical.xml.xcede.Studylevel;
import clinical.xml.xcede.Studylevel_g;
import clinical.xml.xcede.SubjectData_g;
import clinical.xml.xcede.SubjectRef;
import clinical.xml.xcede.SubjectVar;
import clinical.xml.xcede.SubjectVar_g;
import clinical.xml.xcede.Subjectlevel;
import clinical.xml.xcede.Subjectlevel_g;
import clinical.xml.xcede.SummaryValue;
import clinical.xml.xcede.VisitData_g;
import clinical.xml.xcede.VisitRef;
import clinical.xml.xcede.Visitlevel;
import clinical.xml.xcede.Visitlevel_g;
import clinical.xml.xcede.types.ValueTypes_t;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SeriesExporter.java 89 2009-08-17 23:31:45Z bozyurt $
 */
public class SeriesExporter {
	Properties props = null;
	private static Log log = LogFactory.getLog("SeriesExporter");

	public SeriesExporter() {
	}

	protected void shutdown() {
		String dbID = props.getProperty("fbirn.dbid");
		try {
			DBPoolService.getInstance(dbID).shutdown();
		} catch (Exception x) {
		}
	}

	protected UserInfo startup() throws Exception {
		if (props == null) {
			props = GenUtils.loadProperties("clinical.properties");
		}
		Class.forName("oracle.jdbc.driver.OracleDriver");
		Class.forName("org.postgresql.Driver");

		String usersFile = props.getProperty("fbirn.users_file");
		String dbID = props.getProperty("fbirn.dbid");

		SimpleSecurityService secService = SimpleSecurityService
				.getInstance(usersFile);

		DBPoolService.getInstance(secService, secService.getDBConfigMap());
		DBPoolService poolService;
		for (DBConfig dbConfig : secService.getDBConfigMap().values()) {
			if (dbConfig.getId().equals(dbID)) {
				poolService = DBPoolService.getInstance(dbConfig.getId());
				poolService.startup();
				secService.prepareTableCache(dbConfig.getId());
			}
		}

		UserInfo ui = secService.authenticate("admin", secService.getDBConfig(
				dbID).getUser("admin").getPwd(), dbID);
		return ui;
	}

	public void exportExperiment(UserInfo ui, int experimentID, Writer out)
			throws Exception {
		try {
			Projectlevel pl = prepareProjectLevel(ui, experimentID);
			pl.marshal(out);
		} catch (Exception e) {
			log.error("exportExperiment", e);
			throw e;
		}
	}

	public void exportSubject(UserInfo ui, String subjectID, int experimentID,
			Writer out) throws Exception {
		try {
			Subjectlevel sl = prepareSubjectLevel(ui, subjectID, experimentID);
			sl.marshal(out);
		} catch (Exception x) {
			log.error("exportSubject", x);
			throw x;
		}
	}

	public Projectlevel prepareProjectLevel(UserInfo ui, int experimentID)
			throws Exception {
		String dbID = ApplicationUtils.getProperty("fbirn.dbid");

		IExperimentManagement iem = ServiceFactory
				.getExperimentManagement(dbID);
		List<Subjexperiment> subjExpList = iem.getEnrolledSubjects(ui,
				experimentID);
		Experiment exp = iem.getExperiment(ui, experimentID);
		Projectlevel projectLevel = new Projectlevel();
		Projectlevel_g plg = new Projectlevel_g();
		projectLevel.setProjectlevel_g(plg);

		ProjectData_g pdg = new ProjectData_g();
		pdg.setID(exp.getName());
		pdg.setDescription(exp.getDescription());
		plg.setProjectData_g(pdg);
		for (Subjexperiment subjExp : subjExpList) {
			String subjectID = subjExp.getSubjectid();
			Subjectlevel sl = prepareSubjectLevel(ui, subjectID, experimentID);
			clinical.xml.xcede.Subject s = new clinical.xml.xcede.Subject();
			s.setSubjectlevel_g(sl.getSubjectlevel_g());
			plg.addSubject(s);
		}

		return projectLevel;
	}

	public Subjectlevel prepareSubjectLevel(UserInfo ui, String subjectID,
			int experimentID) throws Exception {
		String dbID = ApplicationUtils.getProperty("fbirn.dbid");

		ISubjectVisitManagement visitMan = ServiceFactory
				.getSubjectVisitManagement(dbID);

		List<Visit> visits = visitMan.getAllVisitsForSubject(ui, subjectID);

		Subjectlevel subjectLevel = new Subjectlevel();
		Subjectlevel_g slg = new Subjectlevel_g();
		subjectLevel.setSubjectlevel_g(slg);

		for (Visit visit : visits) {
			clinical.xml.xcede.Visit xcedeVisit = new clinical.xml.xcede.Visit();
			Visitlevel vl = prepareVisitLevel(ui, subjectID, experimentID,
					visit.getComponentID());
			xcedeVisit.setVisitlevel_g(vl.getVisitlevel_g());
			slg.addVisit(xcedeVisit);
		}
		return subjectLevel;
	}

	public Studylevel prepareStudyLevel(UserInfo ui, String subjectID,
			int experimentID, int visitID, int studyID) throws Exception {
		String dbID = ApplicationUtils.getProperty("fbirn.dbid");
		ISubjectVisitManagement visitMan = ServiceFactory
				.getSubjectVisitManagement(dbID);
		Visit theVisit = getTheVisit(ui, subjectID, experimentID, visitID,
				visitMan);
		if (theVisit == null) {
			throw new Exception("No visit with ID " + visitID + " for subject "
					+ subjectID);
		}
		VisitInfo visitInfo = getTheVisitInfo(ui, dbID, subjectID,
				experimentID, visitID);

		Studylevel studylevel = null;

		for (Study study : theVisit.getStudies()) {
			if (study.getStudyID() == studyID) {
				studylevel = new Studylevel();
				Studylevel_g slg = new Studylevel_g();

				studylevel.setStudylevel_g(slg);
				StudyData_g sdg = new StudyData_g();
				slg.setStudyData_g(sdg);
				sdg.setID(study.getName());

				for (StudySegment ss : study.getStudySegments()) {
					Serieslevel sl = prepareSeriesLevel(ui, subjectID,
							experimentID, theVisit.getComponentID(), study
									.getStudyID(), ss.getSegmentID(), theVisit,
							visitInfo);
					Series series = new Series();
					series.setSerieslevel_g(sl.getSerieslevel_g());
					slg.addSeries(series);
				}

				break;
			}
		}
		return studylevel;
	}

	public Visitlevel prepareVisitLevel(UserInfo ui, String subjectID,
			int experimentID, int visitID) throws Exception {
		String dbID = ApplicationUtils.getProperty("fbirn.dbid");
		ISubjectVisitManagement visitMan = ServiceFactory
				.getSubjectVisitManagement(dbID);
		Visit theVisit = getTheVisit(ui, subjectID, experimentID, visitID,
				visitMan);
		if (theVisit == null) {
			throw new Exception("No visit with ID " + visitID + " for subject "
					+ subjectID);
		}

		VisitInfo visitInfo = getTheVisitInfo(ui, dbID, subjectID,
				experimentID, visitID);

		Visitlevel visitLevel = new Visitlevel();
		Visitlevel_g vlg = new Visitlevel_g();
		visitLevel.setVisitlevel_g(vlg);
		VisitData_g vdg = prepareVisitData(theVisit);
		vlg.setVisitData_g(vdg);
		// default study

		if (!theVisit.getVisitSegments().isEmpty()) {
			clinical.xml.xcede.Study xcedeStudy = new clinical.xml.xcede.Study();
			Studylevel_g slg = new Studylevel_g();
			StudyData_g sdg = new StudyData_g();
			xcedeStudy.setStudylevel_g(slg);
			slg.setStudyData_g(sdg);
			sdg.setID("Default Study");
			vlg.addStudy(xcedeStudy);
			for (VisitSegment vs : theVisit.getVisitSegments()) {
				Serieslevel sl = prepareSeriesLevel(ui, subjectID,
						experimentID, theVisit.getComponentID(), -1, vs
								.getSegmentID(), theVisit, visitInfo);
				Series series = new Series();
				series.setSerieslevel_g(sl.getSerieslevel_g());
				slg.addSeries(series);
			}
		}

		for (Study study : theVisit.getStudies()) {
			clinical.xml.xcede.Study xcedeStudy = new clinical.xml.xcede.Study();
			Studylevel_g slg = new Studylevel_g();

			StudyData_g sdg = new StudyData_g();
			xcedeStudy.setStudylevel_g(slg);
			slg.setStudyData_g(sdg);
			sdg.setID(study.getName());

			vlg.addStudy(xcedeStudy);
			for (StudySegment ss : study.getStudySegments()) {
				Serieslevel sl = prepareSeriesLevel(ui, subjectID,
						experimentID, theVisit.getComponentID(), study
								.getStudyID(), ss.getSegmentID(), theVisit,
						visitInfo);
				Series series = new Series();
				series.setSerieslevel_g(sl.getSerieslevel_g());
				slg.addSeries(series);
			}
		}
		return visitLevel;
	}

	public VisitData_g prepareVisitData(Visit visit) {
		VisitData_g vdg = new VisitData_g();
		vdg.setID(visit.getComponentIDAsString());
		return vdg;
	}

	public String[] getAllSubjects(UserInfo ui) throws Exception {
		String dbID = ApplicationUtils.getProperty("fbirn.dbid");
		ISubjectVisitManagement isvm = ServiceFactory
				.getSubjectVisitManagement(dbID);
		SearchCriteria sc = new SearchCriteria(new SearchPredicateList());
		List<Humansubject> humanSubjects = isvm.getMatchingSubjects(ui, sc);
		String[] subjectIDs = new String[humanSubjects.size()];
		int i = 0;
		for (Iterator<Humansubject> iter = humanSubjects.iterator(); iter
				.hasNext();) {
			Humansubject hs = iter.next();
			subjectIDs[i] = hs.getSubjectid();
			// System.out.println("subjectIDs["+ i + "]=" + subjectIDs[i]);
			++i;
		}
		return subjectIDs;
	}

	public String[] getExpSubjects(UserInfo ui, int expID) throws Exception {
		String dbID = ApplicationUtils.getProperty("fbirn.dbid");
		ISubjectVisitManagement isvm = ServiceFactory
				.getSubjectVisitManagement(dbID);
		List<Subjexperiment> list = isvm.getSubjectsForExperiment(ui, expID);
		int i = 0;
		String[] subjExps = new String[list.size()];

		for (Subjexperiment se : list) {
			subjExps[i++] = se.getSubjectid();
		}
		return subjExps;
	}

	// to granular ??
	public int[] getAllExperimentIDs(UserInfo ui) throws Exception {

		String dbID = ApplicationUtils.getProperty("fbirn.dbid");
		ISubjectVisitManagement isvm = ServiceFactory
				.getSubjectVisitManagement(dbID);

		List<Experiment> exps = isvm.getAllExperiments(ui);
		int[] expIDs = new int[exps.size()];
		int i = 0;
		for (Experiment exp : exps) {
			expIDs[i++] = exp.getUniqueid().intValue();
		}
		return expIDs;
	}

	public String[] getExperimentNames(UserInfo ui, int[] expIDs)
			throws Exception {
		String dbID = ApplicationUtils.getProperty("fbirn.dbid");
		ISubjectVisitManagement isvm = ServiceFactory
				.getSubjectVisitManagement(dbID);

		List<Experiment> exps = isvm.getAllExperiments(ui);
		String[] expNames = null;

		Map<Integer, Experiment> expIDMap = new HashMap<Integer, Experiment>();
		for (Iterator<Experiment> iter = exps.iterator(); iter.hasNext();) {
			Experiment exp = iter.next();
			expIDMap.put(new Integer(exp.getUniqueid().toString()), exp);
		}
		exps = new LinkedList<Experiment>();
		for (int i = 0; i < expIDs.length; i++) {
			Experiment exp = expIDMap.get(new Integer(expIDs[i]));
			if (exp != null) {
				exps.add(exp);
			}
		}
		expNames = new String[exps.size()];
		int i = 0;
		for (Iterator<Experiment> iter = exps.iterator(); iter.hasNext();) {
			Experiment exp = iter.next();
			expNames[i++] = exp.getName();
		}
		return expNames;
	}

	public Serieslevel prepareSeriesLevel(UserInfo ui, String subjectID,
			int experimentID, int visitID, int studyID, int segmentID,
			Visit theVisit, VisitInfo visitInfo) throws Exception {
		String dbID = ApplicationUtils.getProperty("fbirn.dbid");

		ISubjectAssessmentManagement isam = ServiceFactory
				.getSubjectAssessmentManagement(dbID);
		// IExperimentManagement expMan =
		// ServiceFactory.getExperimentManagement(dbID);
		ISubjectVisitManagement visitMan = ServiceFactory
				.getSubjectVisitManagement(dbID);

		if (theVisit == null) {
			theVisit = getTheVisit(ui, subjectID, experimentID, visitID,
					visitMan);
		}

		if (visitInfo == null) {
			visitInfo = getTheVisitInfo(ui, dbID, subjectID, experimentID,
					visitID);
		}

		// get the study
		Study theStudy = null;
		for (Study study : theVisit.getStudies()) {
			if (study.getStudyID() == studyID) {
				theStudy = study;
				break;
			}
		}
		StudySegment ss = null;
		VisitSegment vs = null;
		// get the segment also
		if (theStudy != null) {
			ss = findStudySegment(theStudy, segmentID);
		} else {
			vs = theVisit.getVisitSegment(segmentID);
		}

		// prepare XML representation
		Serieslevel sl = new Serieslevel();
		Serieslevel_g slg = new Serieslevel_g();
		sl.setSerieslevel_g(slg);

		SeriesData_g sdg = new SeriesData_g();
		slg.setSeriesData_g(sdg);

		SubjectVar sv = new SubjectVar();
		SubjectVar_g svg = new SubjectVar_g();
		sv.setSubjectVar_g(svg);
		sdg.setSubjectVar(sv);

		setVisitID(visitID, slg);
		// set segment ID
		sdg.setID(String.valueOf(segmentID));
		// set experiment ID
		setExperimentID(experimentID, slg);

		List<AssessmentInfo> assessments = isam.getAssessmentsForSubject(ui,
				subjectID, experimentID);

		if (!assessments.isEmpty()) {
			List<AssessmentScoreValues> asvList = isam
					.getAssessmentValuesForSubject(ui, subjectID, experimentID,
							visitID, segmentID, assessments, -1, true);

			prepareAssessmentData(asvList, svg, assessments);
		}

		prepareScannerSection(ss, vs, sdg, visitInfo);
		prepareProtocolSection(ss, vs, sdg);
		// TODO annotator */
		// prepareSegmentAnnotation(ss, vs, slg);
		prepareStudySection(theStudy, slg);

		SubjectRef xmlSubject = setSubjectID(subjectID);

		slg.setSubjectRef(xmlSubject);

		if (GenUtils.isScanVisitType(theVisit.getVisitType())) {
			// TODO
		}

		// no data rec in DB yet

		Datarec dataRec = new Datarec();
		Datarec_g drg = new Datarec_g();
		dataRec.setDatarec_g(drg);
		return sl;
	}

	private StudySegment findStudySegment(Study study, int segmentID) {
		for (StudySegment ss : study.getStudySegments()) {
			if (ss.getSegmentID() == segmentID) {
				return ss;
			}
		}
		return null;
	}

	private Visit getTheVisit(UserInfo ui, String subjectID, int experimentID,
			int visitID, ISubjectVisitManagement visitMan)
			throws SubjectVisitManagementException {
		Visit theVisit = null;
		List<Visit> visits = visitMan.getAllVisitsForSubject(ui, subjectID);
		for (Visit visit : visits) {
			if (visit.getExperimentID() == experimentID
					&& visit.getComponentID() == visitID) {
				theVisit = visit;
				break;
			}
		}
		return theVisit;
	}

	private VisitInfo getTheVisitInfo(UserInfo ui, String dbID,
			String subjectID, int experimentID, int visitID) throws Exception {
		ISubjectVisitHandler handler = ServiceFactory.getSubjectVisitHandler();
		IDBPoolService dbPoolService = null;
		Connection con = null;
		try {
			dbPoolService = ServiceFactory.getPoolService(dbID);
			con = dbPoolService.getConnection(ui.getName());

			List<VisitInfo> visitInfos = handler.getVisitInfos(dbID, con, subjectID);
			for (VisitInfo vi : visitInfos) {
				int vid = vi.getVisit().getComponentid().intValue();
				if (vid != visitID) {
					continue;
				}
				if (vi.getVisit().getNcExperimentUniqueid().intValue() != experimentID) {
					continue;
				}

				return vi;
			}
		} finally {
			if (dbPoolService != null) {
				dbPoolService.releaseConnection(ui.getName(), con);
			}
		}
		return null;
	}

	public void exportSession(UserInfo ui, String subjectID, int experimentID,
			int visitID, int studyID, int segmentID, Writer out) {
		try {
			System.out.println("TRACE 1");
			Serieslevel sl = prepareSeriesLevel(ui, subjectID, experimentID,
					visitID, studyID, segmentID, null, null);
			System.out.println("TRACE 2");
			sl.marshal(out);
		} catch (Throwable t) {
			log.error("exportSession", t);
			t.printStackTrace();
		}
	}

	public void exportVisit(UserInfo ui, String subjectID, int experimentID,
			int visitID, Writer out) {
		try {
			Visitlevel vl = prepareVisitLevel(ui, subjectID, experimentID,
					visitID);
			vl.marshal(out);
		} catch (Exception x) {
			log.error("exportVisit", x);
		}
	}

	public void exportStudy(UserInfo ui, String subjectID, int experimentID,
			int visitID, int studyID, Writer out) throws Exception {
		try {
			Studylevel sl = prepareStudyLevel(ui, subjectID, experimentID,
					visitID, studyID);
			sl.marshal(out);
		} catch (Exception x) {
			log.error("exportStudy", x);
			throw x;
		}
	}

	private SubjectRef setSubjectID(String subjectID) {
		SubjectRef xmlSubject = new SubjectRef();
		SubjectData_g subjectData = new SubjectData_g();
		xmlSubject.setSubjectData_g(subjectData);
		subjectData.setID(subjectID);
		return xmlSubject;
	}

	private void setVisitID(int visitID, Serieslevel_g slg) {
		VisitRef v = new VisitRef();
		slg.setVisitRef(v);
		VisitData_g vdg = new VisitData_g();
		v.setVisitData_g(vdg);
		vdg.setID(String.valueOf(visitID));
	}

	private void setExperimentID(int experimentID, Serieslevel_g slg) {
		ProjectRef project = new ProjectRef();
		ProjectData_g projdg = new ProjectData_g();
		project.setProjectData_g(projdg);
		projdg.setID(String.valueOf(experimentID));
		slg.setProjectRef(project);
	}

	private void prepareProtocolSection(StudySegment ss, VisitSegment vs,
			SeriesData_g sdg) {
		ExpProtocol expProtocol = new ExpProtocol();
		ExpProtocol_g epg = new ExpProtocol_g();
		if (ss != null) {
			epg.setID(ss.getProtocolID());
			epg.setName(ss.getProtocolID());
		} else if (vs != null) {
			epg.setID(vs.getProtocolID());
			epg.setName(vs.getProtocolID());
		}

		expProtocol.setExpProtocol_g(epg);
		sdg.setExpProtocol(expProtocol);
	}

	/*
	 * private void prepareSegmentAnnotation(StudySegment ss, VisitSegment vs,
	 * Serieslevel_g slg) { Annotation an = new Annotation(); Annotation_g ang =
	 * new Annotation_g(); an.setAnnotation_g(ang); if (ss != null) { if
	 * (ss.getDescription() != null) { ang.setText(ss.getDescription());
	 * getLevelcommon_g(slg).addAnnotation(an); } } else if (vs != null) { if
	 * (vs.getDescription() != null) { ang.setText(vs.getDescription());
	 * getLevelcommon_g(slg).addAnnotation(an); } } }
	 * 
	 * 
	 * private Levelcommon_g getLevelcommon_g(Serieslevel_g slg) { if
	 * (slg.getLevelcommon_g() == null) { Levelcommon_g lcg = new
	 * Levelcommon_g(); slg.setLevelcommon_g(lcg); } return
	 * slg.getLevelcommon_g(); }
	 */

	private void prepareScannerSection(StudySegment ss, VisitSegment vs,
			SeriesData_g sdg, VisitInfo vi) {
		Scanner scanner = new Scanner();
		Scanner_g sg = new Scanner_g();

		int segmentID = -1;
		if (ss != null) {
			segmentID = ss.getSegmentID();
			if (ss.getDescription() != null) {
				System.err.println("description " + ss.getDescription());
			}
			if (ss.getEquipment() != null) {
				sg.setManufacturer(ss.getEquipment().getMake());
				sg.setModel(ss.getEquipment().getModel());
			}
		} else if (vs != null) {
			segmentID = vs.getSegmentID();
			if (vs.getEquipment() != null) {
				sg.setManufacturer(vs.getEquipment().getMake());
				sg.setModel(vs.getEquipment().getModel());
			}
		}
		if (segmentID != -1) {
			Collectionequipment ce = vi.getEquipment(segmentID);
			if (ce != null) {
				sg.setManufacturer(ce.getMake());
				sg.setModel(ce.getModel());
			}
		}
		scanner.setScanner_g(sg);
		sdg.setScanner(scanner);
	}

	private void prepareStudySection(Study theStudy, Serieslevel_g slg) {
		if (theStudy != null) {
			StudyRef xmlStudy = new StudyRef();
			StudyData_g studyData = new StudyData_g();
			xmlStudy.setStudyData_g(studyData);
			studyData.setID(theStudy.getName());
			slg.setStudyRef(xmlStudy);
		}
	}

	private void prepareAssessmentData(List<AssessmentScoreValues> asvList,
			SubjectVar_g svg, List<AssessmentInfo> assessments) {

		Map<Integer, AssessmentInfo> asiMap = new HashMap<Integer, AssessmentInfo>(
				17);
		for (Iterator<AssessmentInfo> iter = assessments.iterator(); iter
				.hasNext();) {
			AssessmentInfo asi = iter.next();
			asiMap.put(new Integer(asi.getAssessmentID()), asi);
		}
		for (AssessmentScoreValues asv : asvList) {
			Assessment as = new Assessment();
			as.setName(asv.getAssessmentName());
			AssessmentInfo asi = asiMap.get(new Integer(asv.getAssessmentID()));

			as.setDescription(asi.getDescription() == null ? "" : asi
					.getDescription());
			for (ScoreValue sv : asv.getScoreValues()) {
				AssessmentValue av = new AssessmentValue();
				av.setSummaryName(sv.getName());
				SummaryValue sumVal = new SummaryValue();
				sumVal.setActualValue(sv.getUncorrectedValue() == null ? "N/A"
						: sv.getUncorrectedValue());

				sumVal.setDataClassification(getMatchingValueType(sv
						.getScoreType()));
				av.setSummaryValue(sumVal);
				as.addAssessmentValue(av);
			}
			svg.addAssessment(as);
		}
	}

	public static ValueTypes_t getMatchingValueType(String scoreType) {
		if (scoreType == null) {
			return null;
		}
		if (scoreType.equals("varchar")) {
			return ValueTypes_t.VARCHAR;
		} else if (scoreType.equals("integer")) {
			return ValueTypes_t.INTEGER;
		} else if (scoreType.equals("float")) {
			return ValueTypes_t.FLOAT;
		} else if (scoreType.equals("boolean")) {
			return ValueTypes_t.BOOLEAN;
		} else {
			return null;
		}
	}

	public static void main(String[] args) throws Exception {
		SeriesExporter se = new SeriesExporter();
		UserInfo ui = null;
		StringWriter out = null;
		try {
			ui = se.startup();
			// ApplicationUtils.authenticate("b","", "test_fbirn");
			out = new StringWriter();
			// se.exportSession(ui, "009004127231", 176, 2, -1, 1, out);
			// se.exportVisit(ui, "009004127231", 176, 2, out);
			// se.exportSubject(ui, "009004127231", 176, out);
			se.exportSubject(ui, "001100000103", 1013, out);
			// System.out.println(out.toString() );
			XMLUtils.prettyPrint(out.toString());
		} finally {
			se.shutdown();
		}
	}

}
