package clinical.xml.importer;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.jdom.Document;
import org.jdom.Element;

import clinical.server.vo.Humansubject;
import clinical.server.vo.Subjexperiment;
import clinical.utils.GenUtils;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.common.query.SearchCriteria;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.query.SearchPredicateList;
import clinical.web.common.security.DBConfig;
import clinical.web.exception.SubjectVisitManagementException;
import clinical.web.services.DBPoolService;
import clinical.web.services.SimpleSecurityService;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.vo.ScoreValue;
import clinical.web.vo.Subject;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;
import clinical.xml.ApplicationUtils;
import clinical.xml.xcede.AssessmentValue;
import clinical.xml.xcede.Series;
import clinical.xml.xcede.SeriesData_g;
import clinical.xml.xcede.SubjectVar_g;
import clinical.xml.xcede.Subjectlevel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: XCEDEImporter.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class XCEDEImporter {
   Properties props = null;

   public XCEDEImporter() {}

   protected void shutdown() {
      String dbID = props.getProperty("mbirn.dbid");
      try {
         DBPoolService.getInstance(dbID).shutdown();
      } catch (Exception x) {}
   }

   protected UserInfo startup() throws Exception {
      if (props == null) {
         props = GenUtils.loadProperties("clinical.properties");
      }
      Class.forName("oracle.jdbc.driver.OracleDriver");
      Class.forName("org.postgresql.Driver");

      String usersFile = props.getProperty("mbirn.users_file");
      String dbID = props.getProperty("mbirn.dbid");

      SimpleSecurityService secService = SimpleSecurityService
            .getInstance(usersFile);

      DBPoolService.getInstance(secService, secService.getDBConfigMap());
      DBPoolService poolService;
      for (Object element : secService.getDBConfigMap().values()) {
         DBConfig dbConfig = (DBConfig) element;
         if (dbConfig.getId().equals(dbID)) {
            poolService = DBPoolService.getInstance(dbConfig.getId());
            poolService.startup();
            secService.prepareTableCache(dbConfig.getId());
         }
      }

      UserInfo ui = secService.authenticate("admin", secService.getDBConfig(
            dbID).getUser("admin").getPwd(), dbID);
      return ui;
   }

   public void importSubject(UserInfo ui, Reader in) throws Exception {
      Subjectlevel sl = (Subjectlevel) Subjectlevel.unmarshal(in);

      String dbID = ApplicationUtils.getProperty("mbirn.dbid");
      ISubjectVisitManagement visitMan = ServiceFactory
            .getSubjectVisitManagement(dbID);

      // List visits = visitMan.getAllVisitsForSubject(ui, subjectID);

      clinical.xml.xcede.Visit[] visits = sl.getSubjectlevel_g().getVisit();
      if (visits == null) {
         // nothing to import
         return;
      }
      String subjectID = findSubjectID(visits[0]);
      String projectID = findProjectID(visits[0]);
      if (subjectID == null && projectID == null) {
         throw new Exception("Both subject ID and ProjectID is required!");
      }

      List<Subjexperiment> expSubjList = getExpSubjectsList(ui, visitMan,
            subjectID, projectID);

      if (expSubjList.isEmpty()) {
         // check if there is a subject in humansubject table
         Humansubject hs = getHumanSubject(ui, visitMan, subjectID);
         if (hs == null) {
            // no subject is found so add the subject
            throw new Exception("Subject " + subjectID + " does not exist!");
         }
         throw new Exception("Subject " + subjectID + " is not enrolled!");
      }

      // Subjexperiment subjExp = expSubjList.get(0);

      /** @todo needs project (experiment) based filtering */
      List<Visit> visitList = visitMan.getAllVisitsForSubject(ui, subjectID);
      Map<String, Map<String, String>> visitID2StudyNamesMap = prepVisitID2StudyNamesMap(visits);
      if (visitList.size() < visits.length) {
         throw new Exception("Some visits are not available in database!");
      }
      for (Visit visit : visitList) {
         Map<String, String> studyNameMap = visitID2StudyNamesMap.get(String
               .valueOf(visit.getComponentID()));
         if (studyNameMap == null) {
            continue;
         }
         if (studyNameMap.get("Default Study") != null) {
            List<VisitSegment> visitSegments = visit.getVisitSegments();
            if (visitSegments.isEmpty()) {
               clinical.xml.xcede.Visit v = findVisit(visit
                     .getComponentIDAsString(), visits);
               importVisitSegments(ui, visitMan, visit, v);
            } else {
               throw new Exception("Visit " + visit.getComponentIDAsString()
                     + " already has segments for Default Study!");
            }
         }
         // TODO
         // for (Study study : visit.getStudies()) {
         // }
      }
   }

   clinical.xml.xcede.Visit findVisit(String visitID,
         clinical.xml.xcede.Visit[] visits) {
      for (int i = 0; i < visits.length; i++) {
         if (visits[i].getVisitlevel_g().getVisitData_g().getID().equals(
               visitID)) {
            return visits[i];
         }
      }
      return null;
   }

   protected void importVisitSegments(UserInfo ui,
         ISubjectVisitManagement visitMan, Visit dbVisit,
         clinical.xml.xcede.Visit visit) {
      /** @todo */
      clinical.xml.xcede.Study study = visit.getVisitlevel_g().getStudy(0);
      Series[] series = study.getStudylevel_g().getSeries();

      for (int i = 0; i < series.length; i++) {

         // visitMan.addVisitSegmentForSubject(ui, vs);
      }

   }

   VisitSegment prepareVisitSegment(Series series, Visit dbVisit) {
      VisitSegment vs = new VisitSegment();
      // SeriesData_g sdg = series.getSerieslevel_g().getSeriesData_g();
      vs.setVisitID(dbVisit.getComponentID());
      vs.setExperimentID(dbVisit.getExperimentID());
      vs.setSubjectID(dbVisit.getSubjectID());
      // XCEDE missing timestamp in series level

      /** @todo */
      // sdg.getLevelcommon_g().getAnnotation(0).getAnnotation_g().
      return vs;
   }

   void prepareAssessmentScoreValues(SeriesData_g sdg,
         List<AssessmentInfo> asiList, String subjectID, int expID,
         int visitID, int segmentID) {
      Map<String, AssessmentInfo> asiMap = new HashMap<String, AssessmentInfo>();
      /** @todo assumption assessment names are unique */
      for (Object element : asiList) {
         AssessmentInfo asi = (AssessmentInfo) element;
         asiMap.put(asi.getName(), asi);
      }

      SubjectVar_g svg = sdg.getSubjectVar().getSubjectVar_g();
      clinical.xml.xcede.Assessment[] asArr = svg.getAssessment();
      for (int i = 0; i < asArr.length; i++) {
         AssessmentInfo asi = asiMap.get(asArr[i].getName());
         assert (asi != null);
         AssessmentScoreValues asv = new AssessmentScoreValues(asi);
         asv.setSubjectID(subjectID);
         asv.setExperimentID(expID);
         asv.setVisitID(visitID);
         asv.setSegmentID(segmentID);

         AssessmentValue[] values = asArr[i].getAssessmentValue();
         for (int j = 0; j < values.length; j++) {
            String scoreName = values[j].getSummaryName();
            String scoreValue = values[j].getSummaryValue().getActualValue();
            /** @todo assumption only single valued scores */
            asv.addScoreValue(new ScoreValue(scoreName, scoreValue, 1));
            // informant Relation, Informant ID, Timestamp are missing from
            // XCEDE
            // clinical rater is missing from XCEDE

         }

      }
   }

   private Map<String, Map<String, String>> prepVisitID2StudyNamesMap(
         clinical.xml.xcede.Visit[] visits) {
      Map<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(
            7);

      for (int i = 0; i < visits.length; ++i) {
         String visitID = visits[i].getVisitlevel_g().getVisitData_g().getID();
         Map<String, String> studyNameMap = map.get(visitID);
         if (studyNameMap == null) {
            studyNameMap = new HashMap<String, String>(3);
            map.put(visitID, studyNameMap);
         }
         clinical.xml.xcede.Study[] studies = visits[i].getVisitlevel_g()
               .getStudy();
         for (int j = 0; j < studies.length; j++) {
            String studyName = studies[i].getStudylevel_g().getStudyData_g()
                  .getID();
            studyNameMap.put(studyName, studyName);
         }
      }
      return map;
   }

   public void importSubject(UserInfo ui, Document doc) throws Exception {
      /** @todo */

      String dbID = ApplicationUtils.getProperty("mbirn.dbid");

      ISubjectVisitManagement visitMan = ServiceFactory
            .getSubjectVisitManagement(dbID);

      // ISubjectAssessmentManagement isam = ServiceFactory
      // .getSubjectAssessmentManagement(dbID);

      List<?> visitElems = doc.getRootElement().getChildren("visit");
      if (visitElems == null) {
         // nothing to import
         return;
      }
      Element visitElem = (Element) visitElems.get(0);
      String subjectID = findSubjectID(visitElem);
      String projectID = findProjectID(visitElem);
      if (subjectID == null && projectID == null) {
         throw new Exception("Both subject ID and ProjectID is required!");
      }

      List<Subjexperiment> expSubjList = getExpSubjectsList(ui, visitMan,
            subjectID, projectID);

      if (expSubjList.isEmpty()) {
         // check if there is a subject in humansubject table
         Humansubject hs = getHumanSubject(ui, visitMan, subjectID);
         if (hs == null) {
            // no subject is found so add the subject
            throw new Exception("Subject " + subjectID + " does not exist!");
         }
         throw new Exception("Subject " + subjectID + " is not enrolled!");
      }

      // Subjexperiment subjExp = expSubjList.get(0);

      /** TODO needs project (experiment) based filtering */
      // List<Visit> visits = visitMan.getAllVisitsForSubject(ui, subjectID);
   }

   @SuppressWarnings("unused")
   private void addSubject(UserInfo ui, ISubjectVisitManagement visitMan,
         String subjectID, String projectID)
         throws SubjectVisitManagementException {
      Subject subject = new Subject();
      subject.setSubjectID(subjectID);
      visitMan.addSubject(ui, subject);

      /** @todo enroll subject */
   }

   private List<Subjexperiment> getExpSubjectsList(UserInfo ui,
         ISubjectVisitManagement visitMan, String subjectID, String projectID)
         throws SubjectVisitManagementException {
      SearchPredicate sp = new SearchPredicate("ncExperimentUniqueid",
            projectID, SearchPredicate.EQUAL, SearchPredicate.INTEGER);

      SearchPredicateList spList = new SearchPredicateList();
      spList.addSearchPredicate(sp, SearchPredicateList.AND);
      SearchPredicate sp2 = new SearchPredicate("subjectID", subjectID,
            SearchPredicate.EQUAL, SearchPredicate.STRING);
      spList.addSearchPredicate(sp2, SearchPredicateList.NONE);

      SearchCriteria sc = new SearchCriteria(spList);
      List<Subjexperiment> expSubjList = visitMan
            .getMatchingExperimentSubjects(ui, sc);
      return expSubjList;
   }

   private Humansubject getHumanSubject(UserInfo ui,
         ISubjectVisitManagement visitMan, String subjectID)
         throws SubjectVisitManagementException {
      SearchPredicateList spList = new SearchPredicateList();
      SearchPredicate sp = new SearchPredicate("subjectID", subjectID,
            SearchPredicate.EQUAL, SearchPredicate.STRING);
      spList.addSearchPredicate(sp, SearchPredicateList.NONE);
      SearchCriteria sc = new SearchCriteria(spList);

      List<Humansubject> hsList = visitMan.getMatchingSubjects(ui, sc);
      if (hsList.isEmpty()) {
         return null;
      }
      return hsList.get(0);
   }

   @SuppressWarnings("unused")
   private Map<String, Map<String, String>> prepVisitID2StudyNamesMap(
         List<?> visitElems) {
      Map<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(
            7);

      for (Iterator<?> iter = visitElems.iterator(); iter.hasNext();) {
         Element vElem = (Element) iter.next();
         String visitID = vElem.getChild("ID").getTextTrim();
         Map<String, String> studyNameMap = map.get(visitID);
         if (studyNameMap == null) {
            studyNameMap = new HashMap<String, String>(3);
            map.put(visitID, studyNameMap);
         }
         List<?> studyElems = vElem.getChildren("study");
         for (Iterator<?> it = studyElems.iterator(); it.hasNext();) {
            Element studyElem = (Element) it.next();
            String studyName = studyElem.getChildTextTrim("ID");
            studyNameMap.put(studyName, studyName);
         }
      }
      return map;
   }

   private String findSubjectID(clinical.xml.xcede.Visit visit) {
      clinical.xml.xcede.Study[] studies = visit.getVisitlevel_g().getStudy();
      if (studies == null) {
         return null;
      }
      // any study will do
      Series[] series = studies[0].getStudylevel_g().getSeries();
      if (series == null) {
         return null;
      }
      return series[0].getSerieslevel_g().getSubjectRef().getSubjectData_g()
            .getID();
   }

   private String findProjectID(clinical.xml.xcede.Visit visit) {
      clinical.xml.xcede.Study[] studies = visit.getVisitlevel_g().getStudy();
      if (studies == null) {
         return null;
      }
      // any study will do
      Series[] series = studies[0].getStudylevel_g().getSeries();
      if (series == null) {
         return null;
      }
      return series[0].getSerieslevel_g().getProjectRef().getProjectData_g()
            .getID();
   }

   private String findSubjectID(Element visitElem) {
      // for subjectLevel
      List<?> sElems = visitElem.getChildren("study");
      if (sElems == null) {
         return null;
      }
      // any study will do
      Element studyElem = (Element) sElems.get(0);
      List<?> seriesElems = studyElem.getChildren("series");
      if (seriesElems == null || seriesElems.isEmpty()) {
         return null;
      }
      Element seriesElem = (Element) seriesElems.get(0);
      Element subjElem = seriesElem.getChild("subject");
      if (subjElem == null) {
         return null;
      }
      return subjElem.getChild("ID").getTextTrim();
   }

   String findProjectID(Element visitElem) {
      // for subjectLevel
      List<?> sElems = visitElem.getChildren("study");
      if (sElems == null) {
         return null;
      }
      // any study will do
      Element studyElem = (Element) sElems.get(0);
      List<?> seriesElems = studyElem.getChildren("series");
      if (seriesElems == null || seriesElems.isEmpty()) {
         return null;
      }
      Element seriesElem = (Element) seriesElems.get(0);
      Element projElem = seriesElem.getChild("project");
      if (projElem == null) {
         return null;
      }
      return projElem.getChild("ID").getTextTrim();
   }

   public static void main(String[] args) throws Exception {
      XCEDEImporter importer = null;
      String xmlFile = "/home/bozyurt/dev/java/BIRN/clinical/test/subject103_3.xml";
      BufferedReader in = null;
      try {
         importer = new XCEDEImporter();
         UserInfo ui = importer.startup();
         in = new BufferedReader(new FileReader(xmlFile));
         importer.importSubject(ui, in);

      } finally {
         if (importer != null) {
            importer.shutdown();
         }
         if (in != null) {
            try {
               in.close();
            } catch (Exception x) { /* ignore */
            }
         }
      }
   }

}
