<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/loci-sec.tld" prefix="sec" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<script>
   function setAction(form, val) {
       form.action.value = val;
       form.submit;
   }
   
   function scheduleDownload(elem) {
     elem.form.action.value = "scheduleDownload";
     onSubmitHandler(elem.form);
   }
   
   function append2List(list, items) {
    for(var i = 0; i < items.length; i++) 
    	list[list.length] = items[i];	
   }
   
   function onSubmitHandler(form) {
    var list = new Array();
   <c:forEach var="item" items="${pdForm.projects}">
    append2List(list, <c:out value="${item.treeId}"/>.getSelectedTitles() );
   </c:forEach>
    var str = "<list>";
    for(var i = 0; i < list.length; i++) {
       str += "<item>" + list[i].path + "</item>";
    }
    str += "</list>";
    form.results.value = str;
   }
   
   // global var 
 var totalSize = 0;
 
 function totalSizeHandler(checkedList, uncheckedList) {
     if ( uncheckedList) {
        // alert("uncheckedList:" + uncheckedList.length );
        var seenSet = new Array();
        for(var i = 0; i < uncheckedList.length; ++i) {
           var payload = uncheckedList[i].payload;
           var nodeId = uncheckedList[i].id;
           if ( payload && !uncheckedList[i].hasChildren) {
              totalSize -= payload;            
           }
        }
     }
     if ( checkedList) {
        //alert("checkedList:" + checkedList.length );
        var seenSet = new Array();        
        for(var i = 0; i < checkedList.length; ++i) {
           var payload = checkedList[i].payload;
           var nodeId = checkedList[i].id           
           if ( payload && !checkedList[i].hasChildren) {
              totalSize += payload;             
           }
        }
     }
     var el = $('size-div');
     if ( el ) {
        str = "Download size : " + utils.formatFileSize(totalSize);
        el.innerHTML=str;
        el.style.backgroundColor ='#D3D3D3'; 
        el.style.border = '1px solid #A9A9A9';
     }
 }
</script>
  
<br/>
<br/>

<div id="alMainPanel">

Welcome <b><bean:write name="container.key" property="userInfo.perceivedName"/></b> 
<bean:message key="site.welcome.greeting.suffix" />
<br/>
<h3>Simple Navigation Instructions:</h3>

<table>
	<tr>
		<th class="mpTH" style="margin-bottom:5px">&nbsp;</th>
		<th class="mpTH" >Experiments</th>
		<th class="mpTH" >&nbsp;</th>
		<th class="mpTH" >Subjects</th>
	</tr>
	
	<tr>

	<sec:hasPrivilege privilege="manageExperiment,read">
	<html:form action="/expman">
	<html:hidden property="action" value=""/>
	<td class="mpTD"><html:image page="/pages/images/search-16.png" alt="Find Experiments" title="Find Experiments" onclick="setAction(this.form,'Show Find')"/></td>
	<td class="mpTD">Find/Query Experiments</td>
	</html:form>
	</sec:hasPrivilege>
	
	<sec:hasPrivilege privilege="manageSubject,read">
	<html:form action="/subjectman">
	<html:hidden property="action" value=""/>
	<td class="mpTD"><html:image page="/pages/images/search-16.png" title="Find Subject" alt="Find Subjects" onclick="setAction(this.form, 'Show Find')"/></td>
	<td>Find/Query Subjects</td>
	</html:form>
	</sec:hasPrivilege>
	
   <sec:hasPrivilege privilege="not manageSubject,read">
	   <td class="mpTD">&nbsp;</td>
	   <td >&nbsp;</td>	   
	</sec:hasPrivilege>
	</tr>

	<tr>

	<sec:hasPrivilege privilege="manageExperiment,admin">
	<html:form action="/expman">
	<html:hidden property="action" value=""/>
	<td class="mpTD"><html:image page="/pages/images/badge-square-plus-16.png" alt="Add Experiment" title="Add Experiment" onclick="setAction(this.form, 'Show Add')"/></td>
	<td class="mpTD">Add Experiment</td>	
	</html:form>
	</sec:hasPrivilege>
	<sec:hasPrivilege privilege="not manageExperiment,admin">
	   <td class="mpTD">&nbsp;</td>
	   <td class="mpTD">&nbsp;</td>	   
	</sec:hasPrivilege>
	


	<sec:hasPrivilege privilege="manageSubject,create-subject">
	<html:form action="/subjectman">
	<html:hidden property="action" value=""/>
	<td class="mpTD"><html:image page="/pages/images/badge-square-plus-16.png" alt="Add Subject" title="Add Subject" onclick="setAction(this.form, 'Show Subject Add')"/></td>
	<td>Add Subject</td>
	</html:form>
	</sec:hasPrivilege>
    <sec:hasPrivilege privilege="not manageSubject,create-subject">
	   <td class="mpTD">&nbsp;</td>
	   <td >&nbsp;</td>	   
	</sec:hasPrivilege>
	</tr>

	<tr>
	<sec:hasPrivilege privilege="manageExperiment,admin">
	<html:form action="/expman">
	<html:hidden property="action" value=""/>
	<td class="mpTD"><html:image page="/pages/images/page-pencil-16.png" alt="Edit Experiments" title="Edit Experiments" onclick="setAction(this.form,'Show Find')"/></td>
	<td class="mpTD">Edit Experiment</td>
	</html:form>
	</sec:hasPrivilege>
    <sec:hasPrivilege privilege="not manageExperiment,admin">
	   <td class="mpTD">&nbsp;</td>
	   <td class="mpTD">&nbsp;</td>	   
	</sec:hasPrivilege>
	
	<sec:hasPrivilege privilege="manageSubject,update,create-subject">
	<html:form action="/subjectman">
	<html:hidden property="action" value=""/>
	<td class="mpTD"><html:image page="/pages/images/page-pencil-16.png" title="Edit Subject" alt="Edit Subjects" onclick="setAction(this.form, 'Show Find')"/></td>
	<td>Edit Subjects</td>
	</html:form>
	</sec:hasPrivilege>
    <sec:hasPrivilege privilege="not manageSubject,update,create-subject">
	   <td class="mpTD">&nbsp;</td>
	   <td>&nbsp;</td>	   
	</sec:hasPrivilege>
	</tr>	

	<tr>
	<th class="mpTH2" ><html:img style="border:0" page="/images/spacer.gif"/></th>
	<th class="mpTH2" >Visits</th>
	<th class="mpTH2" ><html:img style="border:0" page="/images/spacer.gif"/></th>
	<th class="mpTH2" >Assessments</th>
	</tr>

	<tr>
	
	<sec:hasPrivilege privilege="manageSubject,read">
	<html:form action="/subjectman">
	<html:hidden property="action" value=""/>
	<td class="mpTD">
	   <html:image page="/pages/images/search-16.png" title="Find Visit" alt="Find Visit" onclick="setAction(this.form, 'Show Find')"/></td>
	<td class="mpTD">Find/Query Visit</td>
	</html:form>
	</sec:hasPrivilege>
    <sec:hasPrivilege privilege="not manageSubject,read">
	   <td class="mpTD">&nbsp;</td>
	   <td class="mpTD">&nbsp;</td>	   
	</sec:hasPrivilege>
	
<%--     
	<html:form action="/subjectman">
	<html:hidden property="action" value=""/>
	<td class="mpTD"><html:link page="/caquery.do?actionParam=Show" title="Find Assessments">
	<html:img style="border:0" page="/pages/images/search-16.png" title="Query Assessment"/> </html:link>
	</td>
	<td>Find/Query Assessment</td>
	</html:form>
--%>
	 <td class="mpTD">&nbsp;</td>
	 <td>&nbsp;</td>	   
   
	
	</tr>

	<tr>
	<sec:hasPrivilege privilege="manageSubject,update">
	<html:form action="/subjectman">
	<html:hidden property="action" value=""/>
	<td class="mpTD"><html:image page="/pages/images/badge-square-plus-16.png" alt="Add Visit" title="Add Visit" onclick="setAction(this.form, 'Show Find')"/></td>
	<td class="mpTD">Add Visit</td>
	</html:form>
	</sec:hasPrivilege>
    <sec:hasPrivilege privilege="not manageSubject,update">
	    <td class="mpTD">&nbsp;</td>
	    <td class="mpTD">&nbsp;</td>
	</sec:hasPrivilege>

	<sec:hasPrivilege privilege="manageSubject,update">
<%--
	<html:form action="/subjectman">
	<html:hidden property="action" value=""/>
	<td class="mpTD"><html:image page="/pages/images/badge-square-plus-16.png" alt="Add Assessment" title="Add Assessment" onclick="setAction(this.form, 'Show Find')"/></td>
	<td>Add Assessment</td>
	</html:form>
--%>
	    <td class="mpTD">&nbsp;</td>
	    <td >&nbsp;</td>
	</sec:hasPrivilege>
	
	<sec:hasPrivilege privilege="not manageSubject,update">
	    <td class="mpTD">&nbsp;</td>
	    <td class="mpTD">&nbsp;</td>
	</sec:hasPrivilege>
	</tr>

	<tr>
	<sec:hasPrivilege privilege="manageSubject,update">
	<html:form action="/subjectman">
	<html:hidden property="action" value=""/>
	<td class="mpTD" ><html:image page="/pages/images/page-pencil-16.png" title="Edit Visit" alt="Edit Visit" onclick="setAction(this.form, 'Show Find')"/></td>
	<td class="mpTD">Edit Visit</td>
	</html:form>
	</sec:hasPrivilege>
   
	<sec:hasPrivilege privilege="manageSubject,update">
   <%--
	<html:form action="/subjectman">
	<html:hidden property="action" value=""/>
	<td class="mpTD"><html:image page="/pages/images/page-pencil-16.png" title="Edit Assessment" alt="Edit Assessment" onclick="setAction(this.form, 'Show Find')"/></td>
	<td>Edit Assessment</td>
	</html:form>
  --%>
	    <td class="mpTD" >&nbsp;</td>
	    <td>&nbsp;</td>
	</sec:hasPrivilege>
	<sec:hasPrivilege privilege="not manageSubject,update">
	    <td class="mpTD" >&nbsp;</td>
	    <td class="mpTD" >&nbsp;</td>
	    <td class="mpTD" >&nbsp;</td>
	    <td class="mpTD" >&nbsp;</td>
	</sec:hasPrivilege>
	</tr>

</table>


<br></br>
<form method="post" action="<c:url value="/pd.do"/>">
  <input type="hidden" name="action" value=""></input>
  <input type="hidden" name="results" value=""></input>
  <input type="hidden" name="selectedTreeId" value=""></input>
  <input type="hidden" name="willNotify" value="false"></input>
  
  <c:if test="${pdForm.scheduled}">
  <div style="width:420px; background-color:#d8d8d8; padding:5px; border: 2px solid #00659c; margin-bottom:1em; margin-top:1em;" >
     Your archived image download job is successfully scheduled with job ID
     <span style="color:maroon; font-weight:bold;"><c:out value="${pdForm.scheduledJobId}"/> </span>.
     <p>When your tar ball is ready for download,
     you will be notified by the web application visually.
     <c:if test="${pdForm.willNotify}">
        You will be also be notified via email (<c:out value="${pdForm.email}"/>).
     </c:if>
     </p> 
     <p>
     Please check the menu bar on the left side of the browser screen for new results.

     You can view the finished jobs and job status by clicking on 'Manage Jobs'
     link on the menu bar. The Job management screen is dynamically updated. Once your job is
     available on this screen, you can download it to your local machine by clicking 'Download'
     button.</p>
  </div>
  </c:if>
  
  <c:if test="${not empty pdForm.projects}">
  <table style="border-width:0; border-style:solid; border-color:#0000ff" cellpadding="3" cellspacing="0">
     <tr height="35px" >
        <td>
          <span style="font-weight:bold; font-size:larger;" >Available Projects (Experiments)</span>
        </td>
     </tr>      
     <tr height="35px" >
       <td>
         <span style="font-weight:bold" >Download Job Name:</span>
         <html:text name="pdForm" property="bundleName" /><span style="color:red;font-size:10pt;">*</span>
         <div id="size-div" style="width:250px; padding:3px; margin-top:1em;">
         </div>
       </td>
     </tr>
     <c:if test="${pdForm.supportEmail}">
     <tr>
       <td>
         <div style="border:1px dotted aqua; padding:0.5em;">
           <div style="padding-top:2px; padding-bottom:2px;">
            <html:checkbox name="pdForm" property="notifyByEmail">Email Notification</html:checkbox>
           </div>
           <div style="padding-top:2px; padding-bottom:2px;">  
            <b>Notification email:</b>&nbsp;<html:text name="pdForm" property="email" />
           </div> 
         </div>
     </td>
     </tr>
     </c:if>
    <c:forEach var="item" items="${pdForm.projects}">
      <tr>
        <td>
          <div id='item_<c:out value="${item.treeId}"/>'  style="width:420px; margin-bottom:1em;">
             <div>
               <c:out value="${item.description}" />
             </div>
             <script type="text/javascript">
               <c:out value="${item.javascriptTree}" escapeXml="false" />
             </script>
             
          </div>
        </td>
      </tr>   
    
    </c:forEach>
    <tr>
      <td> 
        <div>
                <input type="submit" class="submit-button" value="Schedule Download" 
                  onclick="scheduleDownload(this)"></input>
        </div>
      </td>
    </tr>
  </table>
  </c:if>
</form>
</div>
