<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>


<script language='javascript'
   src='<%=request.getContextPath()%>/pages/raphael-min.js'></script>

<style>
        #canvas {
		    width:384px;
	       border:1px solid #aaa;
		  }		  

        #roiPanel {
          display:none;
        }

        .chosen {
           border:2px solid red;
        }

        .normal {
           border:2px solid #fff; 
        }

        .cell {
            padding:2px;
        }

        fieldset {
          border: 2px groove #d3d3d3;
          margin: 2px;
        }

	 </style>

<div class="error">
    <html:errors/>
</div>


 <div id="roiPanel" class="mainPanel">
     <div class="headerPane">
       <div class="mlarge" style="margin:0 0 0 5px; padding:0;">CBF Ventrical ROI Annotation</div>
    </div>
       <html:form action="/cbfroiannot" styleId="roiForm">
          <input type="hidden" name="action" value="sendMasks"></input>
          <input type="hidden" name="payload" value=""></input>
       <div class="input_div">
         <div id="canvas"></div>
         <div>
            <span id="sliceStatus"></span>&nbsp;
            <span>Dbl-Click to finish, Right-Click to undo.</span>
         </div>
        </div> 
        <div class="button_div">
             <button id="clear-btn" class="submit-button">Clear</button>
             <button id="accept-btn" class="submit-button">Accept</button>
        </div>
        </html:form>
     </div>

     <div id="slice-selector" class="mainPanel">
         <div class="headerPane">
           <div class="mlarge" style="margin:0 0 0 5px; padding:0;">CBF Ventrical ROI Annotation</div>
         </div>
         <div class="input_div">
             <fieldset id="ssPane">
               <legend>Slices</legend>
               <table id="ssTable" style="border:0;">
               </table>
               <div>
                 <span>Please select one or more slices for ROI by clicking on it(them).</span>
               </div>
             </fieldset>
         </div>
         <div class="input_div">
         <div  style="border: 2px groove #d3d3d3; margin:2px;">
             <input type="radio" name="selMode" value="S" checked>Slice Selection Mode &nbsp; &nbsp;
             <input type="radio" name="selMode" value="D">Slice Deselection Mode &nbsp; &nbsp;
         </div>
         </div>
         <div class="button_div">
              <button id="continue-btn" class="submit-button">Continue</button>
         </div>
     </div>


 <script>
       var annot_images = <c:out value="${roiForm.imagePathsJSON}" escapeXml="false" />;
       
       var SliceSelector = function(imgArr) {
           this.images = [];
           for(var i = 0; i< imgArr.length; i++) {
               var img = new Image();
               img.src = "../" + imgArr[i];
               this.images.push(img);
           }
           this.numCols = 6;
           this.numRows = Math.floor(imgArr.length/this.numCols);
           if ( (imgArr.length % this.numCols) > 0) this.numRows += 1;
       };

       SliceSelector.prototype.prepSliceSelectorTable = function() {
           var i,j, k = 0, $te = jQuery('#ssTable'),
             $tr, $td;
           for(i = 0; i < this.numRows; i++) {
               $tr = jQuery('<tr></tr>').appendTo($te);
               for(j = 0; j < this.numCols; j++) {
                  $td = jQuery('<td></td>').appendTo($tr).addClass('cell');
                  if (k < this.images.length) {
                      var $img = jQuery(this.images[k]).addClass('normal');
                      jQuery($img).click(function(e) {
                          var selVal = jQuery('input[name="selMode"]').filter(':checked').val();
                          if (selVal === 'S') {
                              jQuery(this).removeClass('normal').addClass('chosen');
                          } else {
                              jQuery(this).removeClass('chosen').addClass('normal');
                          }
                      });
                      jQuery($td).append($img);
                  }
                  k++;
               }
           }
       };


       var ROIAnnotator = function(img) {
           this.scaleFactor = 6;
           var w = img.width, h = img.height;
           this.img = img;
           this.pathFinished = false;
           this.paper = new Raphael(document.getElementById('canvas'), w * this.scaleFactor, 
                 h * this.scaleFactor);
           this.$canvas =  jQuery(this.paper.canvas); 
           this.path = undefined;
           //this.slice = this.paper.image('mri_brain.jpg',0,0,w, h );
           this.slice = this.paper.image(img.src,0,0,w * this.scaleFactor, h * this.scaleFactor );
           //this.slice.transform("s6");
           this.dots =this.paper.set();
           Raphael.el.addPart = function(point) {
             var parts = this.attr('path') || [];
             parts.push(point);
				 this.attr('path', parts);
			  };
           
           Raphael.el.replacePart = function(point) {
             var parts = this.attr('path');
				 if (parts.length > 1) {
                parts[parts.length -1] = point;
				 } else {
              parts.push(point);
				 }
				this.attr('path', parts);
			 };
			 Raphael.el.removeLastPart = function() {
             var parts = this.attr('path');
				 parts.splice(-1,1);
				 this.attr('path', parts);
			 };

          this.$canvas.bind('click',this, function(e) {
              if (e.data.pathFinished) return;
				  var x,y;
              var c = jQuery('#canvas')[0];
              x = e.pageX - c.offsetLeft;
				  y = e.pageY - c.offsetTop;
              console.log('x:' + x + ', y:' + y);
				  if (!e.data.path) {
                 e.data.path = e.data.paper.path().attr({"stroke-width":1, stroke:"#aaa"});
					  e.data.path.addPart(['M',x,y]);
					  e.data.dots.push(e.data.paper.rect(x-3,y -3,6,6).attr({fill:"#00ff00", 
						    stroke:"#00ff00"}) );
				  } else {
                 e.data.path.addPart(['L',x,y]);
					  e.data.dots.push(e.data.paper.rect(x-3,y -3,6,6).attr({fill:"#00ff00", 
						    stroke:"#00ff00"}));
				  }
			 });
         

         this.$canvas.bind('contextmenu', function(e) { return false; });

         this.$canvas.bind('mousemove', this, function(e) {
            if (!e.data.path || e.data.pathFinished) return;
				var x,y;
              var c = jQuery('#canvas')[0];
            x = e.pageX - c.offsetLeft;
				y = e.pageY - c.offsetTop;
            e.data.path.replacePart(['L',x,y]);
			});

         this.$canvas.bind('mousedown', this, function(e) {
             if (!e.data.path || e.data.pathFinished) return;
             if (e.which === 3) {
                e.preventDefault();
                e.data.path.removeLastPart();
                if (e.data.dots.length > 0) {
				      var lastDot = e.data.dots.splice(-1,1);
                  lastDot.remove();
                }
             }
         });
			 
         this.$canvas.bind('dblclick',this, function(e) {
				  if (e.data.path) {
                 e.data.path.addPart(['Z']);
                 e.data.pathFinished = true;
                 jQuery('#accept-btn').removeAttr('disabled');
                 jQuery('#clear-btn').attr('disabled', true);
				  }
			});
       };


       ROIAnnotator.prototype.clearPath = function() {
           if (this.path) {
               this.path.remove();
               this.dots.remove();
               this.dots = this.paper.set();
               this.path = undefined;
           }
       };
       
       ROIAnnotator.prototype.close = function() {
           if (this.paper) {
              this.paper.remove();
           }
       };


       ROIAnnotator.prototype.isValid = function() {
              return this.pathFinished;
       };

       ROIAnnotator.prototype.getMask = function() {
           var w = this.img.width, h = this.img.height;
           var i, j, x, y, mask = [], sum = 0;
           var bb = this.path.getBBox(true);
           for(i = 0; i < w; i++) {
              mask[i] = [];
              for(j = 0; j < h; j++) {
                  mask[i][j] = 0;
                  x = this.scaleFactor * j;
                  y = this.scaleFactor * i;
                  if (x >= bb.x && x <= bb.x2 && y >= bb.y && y <= bb.y2) {
                    if ( this.path.isPointInside(x,y)) {
                       sum += 1;
                       mask[i][j] = 1;
                    }
                  }
              }
           }
           console.log("sum:" + sum);
           return mask;
       };

       jQuery(function() {
          var selImages = undefined;
          var roi = undefined;
          var masks = [];
          var curSelIdx = -1;
          var sliceSelector = new SliceSelector(annot_images);
          sliceSelector.prepSliceSelectorTable();

          var divElem = jQuery('#roiPanel')[0];
          Rico.Corner.round( divElem, {color: "#ffcc33", corners: 'top'});
          Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});

          var extractSliceNo = function(img) {
             return /(\d+)\.png$/.exec(img.src)[1];
          };

          jQuery('#continue-btn').click(function(e) {
              jQuery('#slice-selector').hide();
              selImages = jQuery('.chosen');
              console.log('selImages:' + selImages);
              curSelIdx = 0;
              if (selImages.length > 1) {
                 jQuery('#accept-btn').text('Next');
              }
              var selImg = selImages[curSelIdx];
              var label = "1 of " + selImages.length + " (" 
                 + extractSliceNo(selImg) + ")";
              jQuery('#sliceStatus').text(label);
              jQuery('#roiPanel').show();
              jQuery('#accept-btn').attr('disabled', true);
              roi = new ROIAnnotator(selImages[curSelIdx]);
          });

          jQuery('#accept-btn').click(function(e) {
              if (!roi)  return;
              
              var mask = roi.getMask();
              masks.push(mask);
              curSelIdx += 1;
              if ( (curSelIdx +1) === selImages.length) {
                 jQuery('#accept-btn').text('Accept');
              }
              if (curSelIdx < selImages.length) {
                  var selImg = selImages[curSelIdx];
                  var label = (curSelIdx + 1) + " of " + selImages.length + " (" 
                    + extractSliceNo(selImg) + ")";
                 jQuery('#sliceStatus').text(label);
                 roi.close();
                 jQuery('#accept-btn').attr('disabled', true);
                 roi = new ROIAnnotator(selImages[curSelIdx]);
              } else {
                 // time to submit 
                 var payload = { sliceNos : [] };
                 payload.masks = masks;
                 for(var i = 0; i < selImages.length; i++) {
                    payload.sliceNos.push( extractSliceNo(selImages[i]) ); 
                 }
                 jQuery('input[name="payload"]').attr('value', JSON.stringify(payload)); 
                 // jQuery('#payload').text(JSON.stringify(payload, null,'  '));
               
                 return true;
              }

              return false;
          });

          jQuery('#clear-btn').click(function(e) {
              if (roi) {
                 roi.clearPath();
              }
              e.preventDefault();
          });
          
       });

</script>
