<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>


<script type="text/javascript">
  function go(elem,actionValue) {
      elem.form.action.value = actionValue;
      elem.form.submit();
      return false;
  } 

  function changeTab(form) {
      form.submit();
      return false;
  }
</script>
<div class="error">
  <html:errors/>
</div>

<html:form action="/accman" styleId="amf">
   <input type="hidden" name="action" value="view" />
</html:form>
<div id="tabpanel">
   <ul id="tabs">
       <li><a href='javascript:{}' onclick="changeTab(jQuery('#amf')[0])">My Account</a></li>
       <li class="activelink"><a href='#'>Contact Info</a></li>
   </ul>
</div>

<html:form action="/contactman" styleId="cmf">
  <input type="hidden" name="action" value=""></input>
  
  <div id="userView">
     <div class="divMainSectionTitle">
       Contact Info 
     </div> 
     <div class="fieldbox"> 
           <div class="input_div">
             <span class="label">User Name:</span> 
             <html:text name="contactForm" property="username" size="20" maxlength="30" disabled="true" /> 
           </div>
           <div class="input_div">
             <span class="label">Email:</span> 
             <html:text name="contactForm" property="email" size="20" maxlength="30" disabled="true" /> 
           </div>
           <div class="input_div">
             <span class="label">First Name (*):</span> 
             <html:text name="contactForm" property="contactInfo.firstName" size="20" maxlength="255" /> 
           </div>
           <div class="input_div">
             <span class="label">Last Name (*) :</span> 
             <html:text name="contactForm" property="contactInfo.lastName" size="20" maxlength="255" /> 
           </div>
           <div class="input_div">
             <span class="label">Title:</span> 
             <html:text name="contactForm" property="contactInfo.title" size="5" maxlength="255" /> 
           </div>
           <div class="input_div">
             <span class="label">Institution:</span> 
             <html:text name="contactForm" property="contactInfo.institution" size="20" maxlength="255" /> 
           </div>
           <div class="input_div">
             <span class="label">Affliation:</span> 
             <html:text name="contactForm" property="contactInfo.affiliation" size="20" maxlength="1024" /> 
           </div>
           
            <div class="input_div">
             <span class="label">Address:</span> 
             <html:textarea name="contactForm" property="contactInfo.addressLine" cols="60" rows="4" /> 
           </div>
           <div class="input_div">
             <span class="label">State (if applicable):</span> 
             <bean:define id="stateList" name="contactForm" property="stateSelector.states"
		          type="java.util.Collection"/>
	         <html:select styleId="stateSelector" name="contactForm" property="stateSelector.selectedState">
			    <html:options collection="stateList" property="value" labelProperty="label" />
             </html:select>
           </div>
           <div class="input_div">
             <span class="label">Zip (if applicable):</span> 
             <html:text name="contactForm" property="contactInfo.zipCode" size="20" maxlength="30" /> 
           </div>
            <div class="input_div">
             <span class="label">Country:</span> 
             <bean:define id="countryList" name="contactForm" property="countrySelector.countries"
		          type="java.util.Collection"/>
	         <html:select styleId="countrySelector" name="contactForm" property="countrySelector.selectedCountry">
			    <html:options collection="countryList" property="value" labelProperty="label" />
             </html:select>
           </div>
           <div class="input_div">
             <span class="label">Phone:</span> 
             <html:text name="contactForm" property="contactInfo.phone" size="20" maxlength="30" /> 
           </div>
           <div class="input_div">
             <span class="label">Fax:</span> 
             <html:text name="contactForm" property="contactInfo.fax" size="20" maxlength="30" /> 
           </div>
           <div class="input_div">
             <span class="label">Notes:</span> 
             <html:textarea name="contactForm" property="contactInfo.notes" cols="60" rows="4" /> 
           </div>
           

	  <div>
             <input type="submit" class="submit-button" value="Save" onclick="return go(this,'save')"></input>
	  </div>

	</div>
   <%-- userView end --%>
  </div>

</html:form>
<script>
     var divElem = jQuery('#userView')[0];
     Rico.Corner.round( divElem,  {color: "#00659c", corners: 'top bottom'});
     var tabs = jQuery('#tabs li');
     tabs.each(
         function() {
            Rico.Corner.round( jQuery(this)[0],  
               {color: "#00659c", corners: 'top'}); }
      );
</script>
