<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>

<style>

 #userView {
   float:left;
   padding:0px;
   padding-bottom: 1em;
   margin-left:10px;
   background-color: #d3d3d3;
   width: 70%;
 }

 .input_div {
   padding-top:5px;
   padding-left:5px;
 }
 
 .divMainSectionTitle {
    background-color: #00659c;
    color: #fff;
    font-weight: bold;
    font-size: larger;
    margin: 0px;
    padding: 0px;
 }
 
 .divSectionTitle {
    background-color: #00659c;
    color: #fff;
    font-weight: bold;
    margin: 0px;
    padding: 0px;
 }

div .label {
    float: left;
    font-weight:bold;
    width: 15em;
    text-align: right;
    margin-right: 10px;
    clear: left;
}

div .label2 {
    float: left;
    font-weight:bold;
    width: 20em;
    text-align: right;
    margin-right: 10px;
    clear: left;
}
</style>

<script type="text/javascript">
  var helpSystem = null;
  window.addOnLoadListener(onLoadHandler);
  
  function go1(elem,actionValue, userType) {
      elem.form.action.value = actionValue;
      elem.form.userType.value = userType;
      elem.form.submit();
      return false;
  } 
  
  function onLoadHandler() {
    var options = [];
    var url = '<html:rewrite page="/help.do?context=db_admin"/>';
    helpSystem = new bal.AjaxHelpSystem(url, options);
    helpSystem.registerButton('help_22'); 
  }
</script>


<div class="error">
  <html:errors/>
</div>

<form method="post" action="<c:url value="/dbconf.do"/>" >
  <input type="hidden" name="action" value="Add"></input>
  <div id="userView">
     <div class="divMainSectionTitle">
        Database Configuration
     </div> 
     <div style="border-left: 2px #00659c solid; border-right: 2px #00659c solid;" > 
        <div >
	  <c:if test="${dconfForm.opType == 'add'}" >
          <div class="input_div">
            <span class="label">Database Id:</span> 
            <html:text name="dconfForm" property="dbId" size="10" maxlength="30" /> 
          </div>
          <div class="input_div">
            <span class="label">Database URL (JDBC):</span> 
            <html:text name="dconfForm" property="dbURL" size="40" maxlength="80" /> 
          </div>
          
          <div class="input_div">
            <span class="label">Site URL:</span> 
            <html:text name="dconfForm" property="siteURL" size="40" maxlength="120" /> 
<%--            <span id="help_22"> <button onclick="return helpHandler('help_22')">
               <img align="middle" class="help_button" src="<%=request.getContextPath()%>/pages/images/questionmark.png" width="19" height="19">
               </button>
            </span>
--%>
            <span id="help_22"></span>
          </div>
          
	      <div class="input_div">
            <bean:define id="dbTypeList" name="dconfForm" property="dbTypeSelector.lvList"
                   type="java.util.Collection"/>
	           <span class="label">Database Type: </span>
	           <html:select name="dconfForm" property="dbTypeSelector.selectedItem">
	              <html:options collection="dbTypeList" property="value" labelProperty="label" />
	           </html:select>
	      </div>
	      <div class="input_div">
	          <bean:define id="siteList" name="dconfForm" property="siteSelector.siteList" 
	             type="java.util.Collection"/>
	          <span class="label">Site: </span>
	           <html:select name="dconfForm" property="siteSelector.selectedSiteUniqueId">
	              <html:options collection="siteList" property="value" labelProperty="label" />
	           </html:select>   
	      </div>
	      
	  <div>
            <input type="submit" class="submit-button" value="Add"></input>
	  </div>
	  </c:if>
	  <c:if test="${dconfForm.opType == 'edit'}" >
	       <div class="input_div">
            <span class="label">Database Id:</span> 
            <html:text name="dconfForm" property="dbId" size="10" maxlength="30" disabled="true" /> 
          </div>
          
          <div class="input_div">
            <span class="label">Database URL (JDBC):</span> 
            <html:text name="dconfForm" property="dbURL" size="40" maxlength="80" /> 
          </div>
          <div class="input_div">
            <span class="label">Site URL:</span> 
            <html:text name="dconfForm" property="siteURL" size="40" maxlength="120" />
            <span id="help_22"> <button onclick="return helpHandler('help_22')">
               <img align="middle" class="help_button" src="<%=request.getContextPath()%>/pages/images/questionmark.png" width="19" height="19">
               </button>
            </span>
          </div>
          <div class="input_div">
            <bean:define id="dbTypeList" name="dconfForm" property="dbTypeSelector.lvList"
                   type="java.util.Collection"/>
	        <span class="label">Database Type: </span>
	        <html:select name="dconfForm" property="dbTypeSelector.selectedItem">
	           <html:options collection="dbTypeList" property="value" labelProperty="label" />
	        </html:select>
          </div> 
	   <div>
             <input type="submit" class="submit-button" value="Edit"></input>
	     </div>
	  </c:if>
     </div>
   </div>

 <%-- userView end --%>
</div>
</form>

<script>
     var divElem = $('userView');
     Rico.Corner.round( divElem,  {color: "#00659c", corners: 'top bottom'});
</script>
