<%@ page contentType="text/html;charset=UTF-8" language="java"%>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean"%>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html"%>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@ taglib uri="/WEB-INF/loci-sec.tld" prefix="sec" %>

<link rel="stylesheet" type="text/css"
	href="<%=request.getContextPath()%>/pages/yui/assets/skins/sam/skin.css"></link>

<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/jquery.tmpl.min.js"></script>
<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/yahoo-dom-event/yahoo-dom-event.js"></script>
<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/dragdrop/dragdrop-min.js"></script>
<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/container/container-min.js"></script>
<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/datasource/datasource-min.js"></script>
<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/element/element-min.js"></script>
<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/paginator/paginator-min.js"></script>

<script type="text/javascript"
	src="<%=request.getContextPath()%>/pages/yui/datatable/datatable-min.js"></script>

<style>
.yui-skin-sam .yui-dt-liner {
	white-space: nowrap;
}

.yui-skin-sam .yui-dt caption {
	font-size: 12px;
}

#report {
	text-align: center;
}

#report table {
	margin-left: auto;
	margin-right: auto;
}

#report,#report .yui-dt-loading {
	text-align: center;
	background-color: transparent;
}

.pivotColumn {
	font-weight: bold;
	font-style: italic;
}

.bold {
  font-weight:bold;
}
div .info {
  margin-top:3px;
  margin-bottom:3px;
}

#detailPanel .bd {
    overflow:auto;
    background-color:#fff; 
	 padding:10px; 
}

.gadesc td, th {
    border-width:1px;
    text-align: center;
}

.garoisum td, th {
    border-width:1px;
    text-align: center;
}

#descPanel .bd {
    overflow:auto;
    background-color:#fff; 
	 padding:10px; 
}

</style>

<script type="text/javascript"> 
   var Data =  <c:out value="${asSelectForm.gaProcRecordsJSONStr}" escapeXml="false" />;
   YAHOO.util.Event.onDOMReady( function() {
      var Dom = YAHOO.util.Dom, Event = YAHOO.util.Event;

      var buildReport = function(repData, oRecord) {
         var d$,od$ = jQuery('<div></div>');
         if (repData['summary_report']) {
             jQuery('<pre></pre>').text(repData['summary_report']).appendTo(od$);
         }
         if (repData['stats_table']) {
             jQuery('<pre></pre>').text(repData['stats_table']).appendTo(od$);
         }
         if (repData['plot_ttest']) {
             d$ = jQuery('<div></div>');
             jQuery('<img></img>').attr('src',repData['plot_ttest']).appendTo(d$);
             jQuery(od$).append(d$);  
         }
         if (repData['plot_pairedttest']) {
             d$ = jQuery('<div></div>');
             jQuery('<img></img>').attr('src',repData['plot_pairedttest']).appendTo(d$);
             jQuery(od$).append(d$);  
         }
         if (repData['plot_anova_rm']) {
             d$ = jQuery('<div></div>');
             jQuery('<img></img>').attr('src',repData['plot_anova_rm']).appendTo(d$);
             jQuery(od$).append(d$);  
         }
         if (repData['plot_anova']) {
             d$ = jQuery('<div></div>');
             jQuery('<img></img>').attr('src',repData['plot_anova']).appendTo(d$);
             jQuery(od$).append(d$);  
         }
         if (repData['plot_anova2']) {
             d$ = jQuery('<div></div>');
             jQuery('<img></img>').attr('src',repData['plot_anova2']).appendTo(d$);
             jQuery(od$).append(d$);  
         }
         if (repData['multicompare']) {
             d$ = jQuery('<div></div>');
             var paths = repData['multicompare'];
             for(var i = 0; i < paths.length; i++) {
                  jQuery('<img></img>').attr('src', paths[i]).appendTo(d$);
                  jQuery('<br/>').appendTo(d$);
             }
             jQuery(od$).append(d$);  
         }
         if (repData['plot']) {
             d$ = jQuery('<div></div>');
             var paths = repData['plot'];
             paths.sort(function(a,b) {
                var i1 = a.indexOf('.png'),
                    i2 = b.indexOf('.png'),
                    n1 = parseInt(a.substring(i1 -1, i1)),
                    n2 = parseInt(b.substring(i2 -1, i2));
                 return n1 - n2;
             });
             for(var i = 0; i < paths.length; i++) {
                  jQuery('<img></img>').attr('src', paths[i]).appendTo(d$);
                  jQuery('<br/>').appendTo(d$);
             }
             jQuery(od$).append(d$);  
         }
         function addActImg(container, level, plane, path) {
            if (!container[level]) {
               container[level]={coronal:"",sagittal:"", axial:""};    
            }
            var obj = container[level];
            obj[plane] = path;  
         }

         var levelActMap = {}, hasAct = false;
         jQuery.each(repData, function(n,v) {
              if (n.indexOf('Axial') == 0) {
                  levelActMap['axial'] = v;
                  hasAct = true;
              } else if (n.indexOf('Coronal') == 0) {
                  levelActMap['coronal'] = v;
                  hasAct = true;
              } else if (n.indexOf('Sagittal') == 0) {
                 levelActMap['sagittal'] = v;
                 hasAct = true;
              }
         });

         var pw = (jQuery(window).width() * 9)/ 10;
         pw += "px";
         if (hasAct) {
          
           jQuery('<h3></h3>').text("Activation Maps").
            css({textAlign:'center'}).appendTo(od$);
           var ad$;
           jQuery('<br></br>').appendTo(od$);
           ad$= jQuery('<div></div>');
           jQuery('<h4></h4>').text('Axial').appendTo(ad$);
           jQuery('<img></img>').attr('src',levelActMap.axial).
              css({width:pw, }).appendTo(ad$);
           jQuery(od$).append(ad$);
           jQuery('<br></br>').appendTo(od$);
           ad$= jQuery('<div></div>');
           jQuery('<h4></h4>').text('Coronal').appendTo(ad$);
           jQuery('<img></img>').attr('src',levelActMap.coronal).
              css({width:pw, }).appendTo(ad$);
           jQuery(od$).append(ad$);
         }
         var roiSummary = oRecord.getData("roiSummary");
         if (roiSummary.header) {
            d$ = jQuery('<div></div>');
            jQuery(od$).append("<br/>").append(d$);
            prepROISummaryTable(d$[0], oRecord);
         }
         d$ = jQuery('<div></div>');
         jQuery(od$).append("<br/>").append(d$);
         prepDescriptionTable(d$[0], oRecord);
         return od$;
      };

      var prepDescriptionTable = function(bodyEl, oRecord) {
         var rowData,i, tg, titleData = {cols:[{text:'Subject ID'},
            {text:'Project'}, {text:'Visit Date'}, {text:'Visit ID'},
            {text:'Job ID'}, {text:'Age'},{text:'Gender'},{text:'Condition'}]};
         var ajviList = oRecord.getData("ajviList");

         tg = new clinical.TableGenerator("gadesc", bodyEl, 
                 titleData, {tableClass:'gadesc'});

         for(i = 0; i < ajviList.length; i++) {
             var ajvi = ajviList[i];
             var jvi = ajvi.jvi
             rowData = { cols:[] };
             rowData.cols.push({text:jvi.subjectID});
             rowData.cols.push({text:jvi.expName});
             rowData.cols.push({text:jvi.visitDate});
             rowData.cols.push({text:jvi.visitID});
             rowData.cols.push({text:jvi.jobID});
             rowData.cols.push({text:ajvi.age});
             rowData.cols.push({text:ajvi.gender});
             rowData.cols.push({text:ajvi.condition});
             tg.addRow(rowData);
         }
      };


      var prepROISummaryTable = function(bodyEl, oRecord) {
          var tg, i, j, titleData = { cols:[]},
          roiSummary = oRecord.getData("roiSummary"),
          header = roiSummary.header, rows = roiSummary.rows,
          row, rowData;

          for(i = 0; i < header.length;i++) {
              titleData.cols.push({text:header[i]});
          }
          tg = new clinical.TableGenerator("garoisum", bodyEl, titleData,
               {tableClass:'garoisum'});
          
          for(i = 0; i < rows.length; i++) {
              row = rows[i].r;
              rowData = { cols:[] };
              for(j = 0; j < row.length; j++) {
                   rowData.cols.push({text:row[j]});
              }
              tg.addRow(rowData);
          }
      };

      var showDescLink = function(elLiner, oRecord, oColumn, oData) {
          var gaName = oRecord.getData('name');
          var aLabel = (gaName && gaName.length > 0) ? gaName : "View"
          if (aLabel !== 'View') {
            elLiner.innerHTML = '<a class="viewable" title="' + aLabel + '" href="">' + aLabel + '</a>';
          } else {
            elLiner.innerHTML = '<a class="viewable" href="">' + aLabel + '</a>';
          }
      };

      var showLink = function(elLiner, oRecord, oColumn, oData) {
          elLiner.innerHTML = '<a class="viewable" href="">View</a>';
      };

      var showDLink = function(elLiner, oRecord, oColumn, oData) {
          elLiner.innerHTML = '<a class="viewable" href="">Download</a>';
      };

      var parseMDYDate = function(value) {
         if (!YAHOO.lang.isString(value) || value === "NA") { return value }
         var toks = value.split('/');
         return new Date(toks[2], toks[0] - 1, toks[1]);
      };

      var myColDefs = [ 
         {key:"jobID", label:"Job ID", sortable:true},
         {key:"jobDate", label:"Date", formatter:"date", sortable:true},
         {key:"analysisType", label:"Job Type", sortable:true},
         {key:"description", label:"Description", formatter: showDescLink},
         {key:"details", label:"Details", formatter: showLink},
 <sec:hasPrivilege privilege="update,create-project,create-subject">
         {key:"download", label:"", formatter: showDLink},
 </sec:hasPrivilege>
      ];
      var ds = new YAHOO.util.DataSource(Data.records);
      ds.responseType = YAHOO.util.DataSource.TYPE_JSARRAY;

      ds.responseSchema = {
          fields: ["jobID",
            {key:"jobDate", parser:parseMDYDate},
            "analysisType","description","details","gaResults",
            "ajviList", "roiSummary","name"] 
      };

      var oConfigs = { paginator: new YAHOO.widget.Paginator( {rowsPerPage: 20} ),
                     caption:"Group Analysis Results Summary"};
      var dt = new YAHOO.widget.DataTable("report", myColDefs, ds, oConfigs);
      dt.on("rowMouseoverEvent", dt.onEventHighlightRow);
      dt.on("rowMouseoutEvent", dt.onEventUnhighlightRow);
      
      var ph = (jQuery(window).height() * 9)/ 10;
      ph = ph + "px";
      var detailPanel = new YAHOO.widget.Panel("detailPanel", { close:true,
         visible:false, modal:true, height:ph, /* width:"500px", height:"200px", */
         autofillheight:"body", constraintoviewport: true });
      //var detailPanel = new YAHOO.widget.Panel("detailPanel", { close:true,
      //   visible:false, modal:true, fixedcenter:true });
      detailPanel.render();

      var descPanel = new YAHOO.widget.Panel("descPanel", {close:true,
         visible:false, modal:true, height:ph, autofillheight:"body",
         fixedcenter:true});
      descPanel.render();

      dt.on('cellClickEvent', function(oArgs) {
         var event = oArgs.event,
             target = oArgs.target,
             oRecord = this.getRecord(target),
             oColumn = this.getColumn(target),
             i;
          
         if (oColumn.key === "details") {
            Event.stopEvent(event);
            var gaResults = oRecord.getData("gaResults");
            var vItems = [];
            var o = {};
            var rootUrl = '<html:rewrite page="/"/>',
                plotPat = /^plot_\d/;
            for(i = 0; i < gaResults.length; i++) {
              var gar = gaResults[i];
              if (gar.type === "tf") {
                  o[gar.name] = gar.context;
              } else {
                  if (gar.name.indexOf('multicompare') == 0) {
                     if (!o['multicompare']) o['multicompare'] = [];
                     o['multicompare'].push(rootUrl + gar.path);
                  } else if (gar.name.match(plotPat)) {
                     if (!o['plot']) o['plot'] = [];
                     o['plot'].push(rootUrl + gar.path);
                  } else {
                     o[gar.name] = rootUrl + gar.path;
                  }
              }
            }
            vItems.push(o);

            detailPanel.setHeader( oRecord.getData('analysisType') + " Details for Job:" + oRecord.getData('jobID'));
            
            var r$ = buildReport(o, oRecord);
            detailPanel.setBody(r$[0]);
            var ph = (jQuery(window).height() * 9)/ 10; // orig 9
            ph = ph + "px";
            //var pw = (jQuery(window).width() * 5)/ 10; 
            //pw = pw + "px";
            detailPanel.cfg.setProperty('height',ph);
            //detailPanel.cfg.setProperty('width',pw);
            detailPanel.show();
         } else if (oColumn.key === "description") {
            Event.stopEvent(event);
            jQuery("#descPanelBody").empty();
            prepDescriptionTable($("descPanelBody"), oRecord);
            descPanel.setHeader( oRecord.getData('analysisType') + " Subjects for Job:" + oRecord.getData('jobID'));
            descPanel.show();
         } else if (oColumn.key === "download") {
            Event.stopEvent(event);
            jQuery("#selJobID").attr("value",oRecord.getData('jobID'));
            jQuery("#garqForm").submit();
         }
      });
   });
</script>

<div class="error"><html:errors /></div>


<div id="mainPanel">
 <div class="yui-skin-sam"
	  style="overflow: auto; margin-left: 5px; margin-right: 5px;">
<html:form styleId="garqForm" action="/gareportquery">
   <input type="hidden" name="actionParam" value="download">
   <input id="selJobID" type="hidden" name="selJobID" value="">
   <div id="report"></div>
</html:form>
   <div id="detailPanel" class="panel" style="visibility:hidden">
        <div id="detailPanelBody" class="bd"></div>
   </div>
   <div id="descPanel" class="panel" style="visibility:hidden">
        <div id="descPanelBody" class="bd"></div>
   </div>
 </div>
</div>
