<%@ page contentType="text/html;charset=UTF-8" language="java"%>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean"%>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html"%>
<%@ taglib uri="/WEB-INF/clinical.tld" prefix="birn"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"  %>

<script  language='javascript'>

 var scatterDataInfo = {};
 <c:if test="${not empty statsForm.olsChartImageFile}">
 scatterDataInfo = <c:out value="${statsForm.scatterDataInfoJSON}" escapeXml="false"/>
 </c:if>

 function showInfo(e, elem, series, item) {
   if (!elem) return;
   var mx = 0;
   var my = 0;

   if (!e)
     e = window.event;
   if (e.pageX || e.pageY)      {
     mx = e.pageX;
     my = e.pageY;
   } else if (e.clientX || e.clientY)   {
     mx = e.clientX + document.body.scrollLeft
       + document.documentElement.scrollLeft;
     my = e.clientY + document.body.scrollTop
       + document.documentElement.scrollTop;
   }
   var content = 'Item ' + item + ' from series ' + series + ' is selected.';
   
   if ( scatterDataInfo) {
      var seriesKey = 'series_' + series;
      var xName = scatterDataInfo[seriesKey].x;
      var yName = scatterDataInfo[seriesKey].y;
      var itemKey = 'k' + series + '_' + item;
      var values = scatterDataInfo.map[itemKey];
      content = '<div><b>SubjectID:</b>&nbsp;' + values[0] + '</div>';
      content += '<div><b>Site:&nbsp;</b>' + values[1] + '</div>';
      content += '<div><b>' + xName + ':</b>&nbsp;' + values[2] +'</div>';
      content +=  '<div><b>' + yName + ':</b>&nbsp;' + values[3] + '</div>';
   }
   bal.Popup.showPopup(mx, my, elem.parentNode, content);
 }
</script>

<br>
<br>
<div class="error">
  <html:errors />
</div>
	<c:if test="${statsForm.statsOptionSelector.selectedStatsOption == 'univariate'}" >

		<table id="uv_stats" border="0" cellspacing="0"  width="80%" bgcolor="white">
		   <tr>
              <td>
                 <table border=0 width="100%" bgcolor="#ffcc33">
                    <tr bgcolor="#ffcc00" height="45">
                      <td class="mlarge">Univariate Statistics Results</td>
                    </tr>
                 </table>
              </td>
           </tr> 
       		
			<tr bgcolor="white" height="15">
				<td>&nbsp;</td>
			</tr>
			
                        <c:if test="${not empty statsForm.descStatsList}" >
			<tr bgcolor="white">
				<td>
				  <table id="desc_stats">
				     <tr>
				       <th>Variable</th>
				       <th>N</th>
				       <th>Mean</th>
				       <th>SD</th>
				       <th>Min</th>
				       <th>Max</th>
				       <th>Kurtosis</th>	
				       <th>Skewness</th>				       
				     </tr>				    
                                     <c:forEach var="ds" items="${statsForm.descStatsList}" > 
				        <tr>
				           <td><c:out value="${ds.varName}" /></td>
				           <td><c:out value="${ds.n}" /></td>
				           <td><fmt:formatNumber maxFractionDigits="2" value="${ds.mean}" /></td>
				           <td><fmt:formatNumber maxFractionDigits="2" value="${ds.SD}" /> </td>
				           <td><fmt:formatNumber maxFractionDigits="2" value="${ds.min}" /> </td>
				           <td><fmt:formatNumber maxFractionDigits="2" value="${ds.max}" /></td>
				           <td><fmt:formatNumber maxFractionDigits="2" value="${ds.kurtosis}" /></td>
				           <td><fmt:formatNumber maxFractionDigits="2" value="${ds.skewness}" /></td>
				        </tr>
				     </c:forEach>
				  </table>											
				 </td>
				</tr>
			</c:if>
			


                        <c:if test="${not empty statsForm.barChartImageFile}" >
				<tr bgcolor="white">
					<td><bean:define id="imgPath" name="statsForm"
						property="barChartImageFile" type="java.lang.String" /> 
						<html:img page="<%= imgPath %>" />
					</td>
				</tr>
				<tr bgcolor="white" height="15">
					<td>&nbsp;</td>
				</tr>
			</c:if>
                        <c:forEach var="srd" items="${statsForm.statResultsDataList}" > 
				<tr bgcolor="#00659c">
					<td><font color="white"><b><bean:write name="srd"
						property="varName" /></b></font></td>
				</tr>
				<tr>
					<td>
					<table border="0" cellspacing="0" cellpadding="0" width="100%"
						bgcolor="#00659c">
						<tr bgcolor="white">
							<td><pre> <bean:write name="srd" property="text" /> </pre></td>
						</tr>
						<tr bgcolor="white">
							<td>
							 <c:if test="${not empty srd.imagePath}">
							   <bean:define id="imgPath" name="srd" property="imagePath" type="java.lang.String" /> 
							   <html:img page="<%= imgPath %>"height="550" width="650" />
							 </c:if> 
							 &nbsp;
							 </td>
						</tr>
					    <c:if test="${not empty srd.qqImagePath}">						
						  <tr bgcolor="white">
							<td>
							   <bean:define id="imgPath" name="srd" property="qqImagePath" type="java.lang.String" /> 
							   <html:img page="<%= imgPath %>"height="550" width="650" />
							 &nbsp;
							 </td>
						  </tr>
					    </c:if> 
						
					</table>
					</td>
				</tr>
			<
                        </c:forEach> 
			<tr>
			  <td>
			   <html:form action="/viewqueryres">
			      <div class="back_button_div">   
	                <html:submit styleClass="submit-button">Back to Search Results</html:submit>
			     </div>
	           </html:form>
              </td>
            </tr> 
		</table>
	
        </c:if>

	<%--  results for bivariate statistics  --%>
	<c:if test="${statsForm.statsOptionSelector.selectedStatsOption == 'bivariate'}">

		<table id="bv_stats" border="0" cellspacing="0"  width="80%" bgcolor="white">
		  <tr>
              <td>
                 <table border=0 width="100%" bgcolor="#ffcc33">
                    <tr bgcolor="#ffcc00" height="45">
                      <td class="mlarge">Bivariate Statistics Results</td>
                    </tr>
                 </table>
              </td>
            </tr>          
			<tr bgcolor="white" height="15">
				<td>&nbsp;</td>
			</tr>

            <tr>
			  <td>
			     <html:form action="/viewqueryres">
			       <div class="back_button_div">   
	                <html:submit styleClass="submit-button">Back to Search Results</html:submit>
			       </div>
	             </html:form>
                 </td>
            </tr> 
			<c:if test="${not empty statsForm.olsChartImageFile}">
				<tr bgcolor="white">
					<td align="center"><bean:define id="imgPath" name="statsForm"
						property="olsChartImageFile" type="java.lang.String" /> 
						<c:out value="${statsForm.imageMapInfo}" escapeXml="false"/>
						<html:img page="<%= imgPath %>" usemap="#chart"/>
					</td>
				</tr>
				<tr bgcolor="white" height="15">
					<td>&nbsp;</td>
				</tr>
			</c:if>
			<c:if test="${not empty statsForm.regressionInfos}">
			
				<tr bgcolor="white">
					<td>
					<table id="reg_table" border="0" width="100%">
						
                                                <c:forEach var="ri" items="${statsForm.regressionInfos}" >
							<tr bgcolor="white">
								<td colspan="4"><b><bean:write name="ri" property="title" /> </b>
								</td>
							</tr>

							<tr bgcolor="white">
								<td><b>Intercept:</b>&nbsp;<c:out value="${ri.interceptValue}" /></td>
								<td><b>Slope:</b>&nbsp;<c:out value="${ri.slopeValue}" /></td>
								<td><b>Pearson's R:</b>&nbsp;<c:out value="${ri.rvalue}" /></td>
								<td><b>Coefficient of Determination R^2:</b>&nbsp;<c:out value="${ri.rsquareValue}" /></td>
							</tr>
							<tr bgcolor="white">
								<td><b>MSE:</b>&nbsp;<c:out value="${ri.meanSquareErrorValue}" /></td>
								<td><b>N:</b>&nbsp;<c:out value="${ri.n}" /></td>
								<c:if test="${ not empty ri.slopeConfidenceInterval}">
									<td colspan="2"><b>half-width of 95% confidence interval for the
									  slope estimate:</b>&nbsp;<c:out value="${ri.slopeConfidenceIntervalValue}" />
									</td>
								</c:if>
								<c:if test="empty ri.slopeConfidenceInterval">
									<td colspan="2">&nbsp;</td>
								</c:if>
							</tr>
						</c:forEach>
					</table>
					</td>
				</tr>
				<tr>
			  <td>
			   <html:form action="/viewqueryres">
			      <div class="back_button_div">   
	                <html:submit styleClass="submit-button">Back to Search Results</html:submit>
			     </div>
	           </html:form>
              </td>
            </tr> 
		   </c:if>
		</table>
	</c:if>


