// common JavaScript functions

function helpHandler(spanId) {
	if (!spanId) {
		return false;
	}
	var mainSpan = document.getElementById(spanId);
	if (mainSpan) {
		var msgId = spanId.substring(spanId.lastIndexOf('_') + 1);
		var content = helpSystem.findHelpMessage(msgId);
		// alert("msgId=" + msgId + " content=" + content);
		if (content) {
			bal.InfoViewer.showPopup(mainSpan, content);
		}
	}
	return false;
}

/* ----- ajax components (IBO) ------------------- */

var clinical = clinical || {};

clinical.BatchJobStatsComp = function(containerId, url, manageURL, options) {
	var parent = document.getElementById(containerId);
	this.url = url;
	this.manageURL = manageURL;
	this.options = options || {};
	this.prevNumOfFinishedJobs = -1;
	this.prevNumOfNewJobs = -1;
	// create the UI of the component and add to the parent
	this.ui = document.createElement("div");
	this.actionLink = document.createElement("div");
	this.actionLink.innerHTML = '<a href="' + this.manageURL
			+ '">Manage Jobs</a>';
	// this.actionLink.style.border = "solid green 1px";
	this.ui.id = "bjs_main_" + containerId;
	this.ui.className = "bjsMain";
	this.txtNode = document.createTextNode("No Batch Jobs");
	this.ui.appendChild(this.txtNode);
	parent.appendChild(this.ui);
	this.ui.appendChild(this.actionLink);

	this.ajaxHelper = new net.ContentLoader(this, url, "POST",
			this.options.requestParameters || []);

   this.pollTimeOut = this.options.pollTimeOut ? this.options.pollTimeOut * 60 * 1000 : 120 * 60 * 1000;
   this.startTime = new Date().getMilliseconds();
}

clinical.BatchJobStatsComp.prototype.ajaxUpdate = function(request) {
	if (!request || !request.responseXML)
		return;
	var jobs = this.handleResponse(request.responseXML.documentElement);
	if (jobs && jobs.length > 0) {

		var finishedJobs = 0;
		var chrashedJobs = 0;
		var newJobs = 0;
		for ( var i = 0; i < jobs.length; i++) {
			var jr = jobs[i];
			if (jr.status === 'finished') {
				finishedJobs++;
				if (jr.newlyAdded === 'true') {
					newJobs++;
				}
			} else if (jr.status === 'finished_with_err') {
				chrashedJobs++;
			}
		}
		// update ui
		this.updateUI(finishedJobs, chrashedJobs, newJobs, jobs);
	}
};

clinical.BatchJobStatsComp.prototype.periodicCheck = function() {
	this.ajaxHelper.sendRequest();
	var thisObj = this;
	var checker = function() {
      var timeElapsed = new Date().getMilliseconds() - thisObj.startTime;
      if (timeElapsed < thisObj.pollTimeOut) {  
		  thisObj.periodicCheck();
      }
	};

	var checkInterval = (this.options && this.options.checkInterval) ? this.options.checkInterval
			: 5000;
	setTimeout(checker, checkInterval);
};

clinical.BatchJobStatsComp.prototype.handleError = function(request) {
	if (this.options.errorHandler) {
		this.options.errorHandler(request);
	}
};

clinical.BatchJobStatsComp.prototype.updateUI = function(finishedJobs,
		chrashedJobs, newJobs, jobs) {
	var str = "", i, cbAjaxHelper, len, param;
	var newlyAdded = [];
	/*
	if (finishedJobs > 0) {
		if (finishedJobs == 1){
			str = finishedJobs + " new result";
		} else {
		   str = finishedJobs + " new results";
		}
		this.txtNode.nodeValue = str;
		this.ui.className = "bjsMainNew";
	} */

	if (newJobs > 0) {
		if (newJobs == 1){
			str = newJobs + " new result";
		} else {
		   str = newJobs + " new results";
		}
		this.txtNode.nodeValue = str;
		this.ui.className = "bjsMainNew";
		if (newJobs != this.prevNumOfNewJobs) {
		   new Effect.Pulsate(this.ui);
		   this.prevNumOfNewJobs = newJobs;
		}
		if (this.options && this.options.cbURL && jobs) {
			param = "jobIDs=";
			len = jobs.length;
			for (i = 0; i < len; ++i) {
				param += jobs[i].id;
				if ((i + 1) < len)
					param += ",";
			}
			cbAjaxHelper = new net.ContentLoader(this, options.cbURL,
					"POST", [ param ]);
			cbAjaxHelper.sendRequest();
		}
	}
};

clinical.BatchJobStatsComp.prototype.handleResponse = function(ajaxResponse) {
	var jobs = [];
	if (!ajaxResponse)
		return;
	var entries = ajaxResponse.getElementsByTagName('jr');
  
	if (entries && entries.length > 0) {
		for ( var i = 0; i < entries.length; ++i) {
			var entry = entries[i];
			var id = "";
			var status = "";
			var user = "";
			var jrDate = "";
			var jrDesc = "";
			var newlyAdded = "false";
			var jrSize = "N/A";
			var jrDownloadCount = "N/A"
			var jrErrMsg = null;

			if (entry.attributes) {
				for ( var j = 0; j < entry.attributes.length; ++j) {
					var nodeName = entry.attributes[j].nodeName.toLowerCase();
					var nodeValue = entry.attributes[j].nodeValue;
					if (nodeName === 'id') {
						id = nodeValue;
					} else if (nodeName === 'status') {
						status = nodeValue;
					} else if (nodeName === 'user') {
						user = nodeValue;
					} else if (nodeName === 'date') {
						jrDate = nodeValue;
					} else if (nodeName === 'new') {
						newlyAdded = nodeValue;
					} else if (nodeName === 'size') {
						jrSize = nodeValue;
					} else if (nodeName === 'count') {
						jrDownloadCount = nodeValue;
					}
				}
			}
			var descElems = entry.getElementsByTagName("desc");
			if (descElems && descElems.length > 0) {
				jrDesc = descElems[0].value;
			}
			var errElems = entry.getElementsByTagName("error");
			if (errElems && errElems.length > 0) {
				jrErrMsg = errElems[0].value;
			}

			jobs.push({
				id : id,
				status : status,
				user : user,
				date : jrDate,
				desc : jrDesc,
				newlyAdded : newlyAdded,
				size : jrSize,
				count : jrDownloadCount,
				error : jrErrMsg
			});
		}
	}
	return jobs;
};

clinical.TableGenerator = function(tableId, container, titleData, options) {
	this.tableId = tableId;
	this.titleData = titleData;
	if (!options || options.length === 0) {
		this.options = {
			normalCellStyle : 'normal',
			updatedCellStyle : 'hilite',
			twoShadeColor : '#E0E0E0'
		};
	} else {
		this.options = options;
		if (!this.options.normalCellStyle)
			this.options.normalCellStyle = 'normal';
		if (!this.options.updatedCellStyle)
			this.options.updatedCellStyle = 'hilite';
		if (!this.options.twoShadeColor)
			this.options.twoShadeColor = '#E0E0E0';
	}
	this.table = document.createElement("table");
	container.appendChild(this.table);
	this.table.setAttribute('id', tableId);
	if (this.options.tableClass) {
		utils.xAddClass(this.table, this.options.tableClass);
	}
	var noCols = titleData.cols.length;
	var thElem = document.createElement("tr");
	this.table.appendChild(thElem);
	for ( var i = 0; i < noCols; i++) {
		var tdEl = document.createElement("th");
		thElem.appendChild(tdEl);
		var divEl = document.createElement("div");
		if (titleData.cols[i].styleClass) {
			utils.xAddClass(divEl, titleData.cols[i].styleClass);
		} else {
			utils.xAddClass(divEl, this.options.normalCellStyle);
		}
		tdEl.appendChild(divEl);
		if (titleData.cols[i].text) {
			var tn = document.createTextNode(titleData.cols[i].text);
			divEl.appendChild(tn);
		}
	}
}

clinical.TableGenerator.prototype.addRow = function(rowData) {
	var rows = this.table.rows;
	var trEl = document.createElement("tr");
	var noCols = rowData.cols.length, i, tn, tdEl, divEl;

	this.table.appendChild(trEl);
	for ( i = 0; i < noCols; i++) {
		tdEl = document.createElement("td");
		trEl.appendChild(tdEl);
		divEl = document.createElement("div");
		if (rowData.cols[i].styleClass) {
			utils.xAddClass(divEl, rowData.cols[i].styleClass);
		} else {
			utils.xAddClass(divEl, this.options.normalCellStyle);
		}
		tdEl.appendChild(divEl);
		if (rowData.cols[i].text) {
			tn = document.createTextNode(rowData.cols[i].text);
			divEl.appendChild(tn);
		}
	}
}
/* ----------------------------- Ajax Dynamic Table ----------------------- */
clinical.DynamicTable = function(tableId, url, options, onSuccessCB,
		initRowData, aLogger) {
	this.tableId = tableId;
	this.url = url;

	if (!options || options.length == 0) {
		this.options = {
			normalCellStyle : 'normal',
			updatedCellStyle : 'hilite',
			twoShadeColor : '#E0E0E0'
		};
	} else {
		this.options = options;
		if (!this.options.normalCellStyle)
			this.options.normalCellStyle = 'normal';
		if (!this.options.updatedCellStyle)
			this.options.updatedCellStyle = 'hilite';
		if (!this.options.twoShadeColor)
			this.options.twoShadeColor = '#E0E0E0';
	}

	this.logger = (aLogger) ? aLogger : null;
	if (this.logger) {
		this.logger.append("DynamicTable - constructor");
	}
	this.table = document.getElementById(tableId);
	var rows = this.table.getElementsByTagName('tr');

	this.numRows = (rows) ? rows.length : 0;
	var cols = (rows) ? rows[0].getElementsByTagName('td') : 0;
	this.numCols = (cols) ? cols.length : 0;
	this.rowDataCache = [];
	if (initRowData) {
		this.rowDataCache = initRowData;
	}
	this.onSuccessCB = onSuccessCB;
	this.applyTwoColor();
	if (url) {
		this.ajaxHelper = new net.ContentLoader(this, url, "POST",
				this.options.requestParameters || []);
	}
}

clinical.DynamicTable.prototype.applyTwoColor = function() {
	if (this.logger) {
		this.logger.append("DynamicTable.applyTwoColor");
	}
	var rows = document.getElementById(this.tableId).getElementsByTagName('tr');
	if (!rows || rows.length == 0)
		return;
	// alert("rows:" + rows.length);
	if (this.logger) {
		this.logger.append("DynamicTable.applyTwoColor - rows:" + rows.length);
	}
	var bgColor = rows[0].style.backgroundColor;
	// assuming the first row as the header row
	for ( var i = 1, len = rows.length; i < len; i++) {
		if (((i - 1) % 2) == 1) {
			rows[i].style.backgroundColor = this.options.twoShadeColor;
		} else {
			rows[i].style.backgroundColor = 'white';
			if (this.logger) {
				this.logger.append("DynamicTable.applyTwoColor - rows[" + i
						+ "]: white");
			}
		}
	}
}

clinical.DynamicTable.prototype.getNumRows = function() {
	return this.numRows;
}

clinical.DynamicTable.prototype.getNumCols = function() {
	return this.numCols;
}

clinical.DynamicTable.prototype.updateColumnsById = function(rowId, colData) {
	if (!colData || !rowId) {
		return;
	}
	var theRow = document.getElementById(rowId);
	if (!theRow) {
		return;
	}
	var i, e, colIdx, tableCol;
	for ( i = 0; i < colData.length; ++i) {
		colIdx = colData[i].colIdx;
		tableCol = theRow.cells[colIdx];
		if (colData[i].textContent) {
			e = tableCol.getElementsByTagName('span')[0];
			tableCol.getElementsByTagName('div')[0].innerHTML = colData[i].textContent;
			if (colData[i].title) {
				tableCol.getElementsByTagName('div')[0].setAttribute("title",
						colData[i].title);
			}
		}
		if (colData[i].newStyleClass) {
			utils.xAddClass(tableCol.getElementsByTagName('div')[0],
					colData[i].newStyleClass);
		}
	}
}

clinical.DynamicTable.prototype.addRow = function(rowData) {
	var tblElem = document.getElementById(this.tableId);
	var rows = tblElem.rows;
	var trElem = null, noCols, i, tdElem, divElem, tn, spanEl;
	if (tblElem.insertRow) {
		trElem = tblElem.insertRow(rows.length);
	} else {
		trElem = document.createElement("tr");
	}
	trElem.id = rowData.rowId;
	trElem.partNum = rowData.partNum;

	noCols = rowData.cols.length;
	for (i = 0; i < noCols; i++) {
		tdElem = document.createElement("td");
		trElem.appendChild(tdElem);
		divElem = document.createElement("div");
		if (rowData.cols[i].styleClass) {
			utils.xAddClass(divElem, rowData.cols[i].styleClass);
		} else {
			utils.xAddClass(divElem, this.options.normalCellStyle);
		}
		tdElem.appendChild(divElem);
		tn = null;
		if (rowData.cols[i].text) {
			tn = document.createTextNode(rowData.cols[i].text);
			if (rowData.cols[i].color) {
				spanEl = document.createElement("span");
				spanEl.style.color = rowData.cols[i].color;
				spanEl.appendChild(tn);
				divElem.appendChild(spanEl);
			} else {
				divElem.appendChild(tn);
			}
		} else {
			if (rowData.cols[i].html) {
				divElem.innerHTML = rowData.cols[i].html;
			} else {
				tn = document.createTextNode("");
				divElem.appendChild(tn);
			}
		}
		if (rowData.cols[i].title) {
			divElem.setAttribute("title", rowData.cols[i].title);
		}
	} // i
	if (!tblElem.insertRow) {
		tblElem.appendChild(trElem);
	}
	this.applyTwoColor();
}

// ajax methods

clinical.DynamicTable.prototype.periodicCheck = function() {
	this.ajaxHelper.sendRequest();
	var thisObj = this;
	var checker = function() {
		thisObj.periodicCheck();
	};
	setTimeout(checker, 15000);
}

clinical.DynamicTable.prototype.ajaxUpdate = function(request) {
	rowData = this.onSuccessCB(request.responseXML.documentElement);
	var newRows = [];
	var updatedRows = [];
	var i, j, len;
	if (rowData) {
		if (this.rowDataCache && this.rowDataCache.length > 0) {
			var rowIdMap = new utils.Hash();
			for ( var i = 0, len = this.rowDataCache.length; i < len; ++i) {
				var cr = this.rowDataCache[i];
				rowIdMap.setItem(cr.rowId, i);
			}
			for (i = 0, len = rowData.length; i < len; ++i) {
				var row = rowData[i];
				if (rowIdMap.hasItem(row.rowId)) {
					var crIdx = rowIdMap.getItem(row.rowId);
					var cr = this.rowDataCache[crIdx];
					// check for any changes
					var cols = row.cols;
					var cachedCols = cr.cols;
					var rowUpdated = false;
					var updatedRow = {
						rowId : cr.rowId,
						cols : []
					};
					for (j = 0; j < cols.length; ++j) {
						if (cols[j].text && cachedCols[j].text
								&& cols[j].text !== cachedCols[j].text) {
							// alert("changed col: " + cols[j].text + " rowId:"
							// + updatedRow.rowId);
							var titleStr = null;
							if (cols[j].title)
								titleStr = cols[j].title;
							var col = {
								colIdx : j,
								textContent : cols[j].text,
								title : titleStr
							};
							if (cols[j].styleClass) {
								col.newStyleClass = cols[j].styleClass;
							} else {
								col.newStyleClass = this.options.updatedCellStyle;
							}
							if (cols[j].color) {
								col.textContent = '<span style="color :'
										+ cols[j].color + ';">'
										+ col.textContent + '</span>';
							}

							// alert("updated col=" + col.colIdx + " ,text:" +
							// col.textContent);
							updatedRow.cols.push(col);
							rowUpdated = true;
						} // if
						// 8/3/07
						if (cols[j].html && cachedCols[j].html
								&& cols[j].html !== cachedCols[j].html) {
							var titleStr = null;
							if (cols[j].title)
								titleStr = cols[j].title;
							var col = {
								colIdx : j,
								textContent : cols[j].html,
								title : titleStr
							};
							if (cols[j].styleClass) {
								col.newStyleClass = cols[j].styleClass;
							} else {
								col.newStyleClass = this.options.updatedCellStyle;
							}
							if (cols[j].color) {
								col.textContent = '<span style="color :'
										+ cols[j].color + ';">'
										+ col.textContent + '</span>';
							}
							updatedRow.cols.push(col);
							rowUpdated = true;
						}// if
					} // j
					if (rowUpdated) {
						updatedRows.push(updatedRow);
						this.rowDataCache[crIdx] = row;
					}
				} else {
					newRows.push(row);
					this.rowDataCache.push(row);
				}
			} // i
		} else {
			for (i = 0, len = rowData.length; i < len; ++i) {
				newRows.push(rowData[i]);
				this.rowDataCache.push(rowData[i]);
			}
		}
		if (updatedRows) {
			for (i = 0, len = updatedRows.length; i < len; ++i) {
				var ur = updatedRows[i];
				this.updateColumnsById(ur.rowId, ur.cols);
			}
		}
		if (newRows) {
			for (i = 0, len = newRows.length; i < len; ++i)
				this.addRow(newRows[i]);
		}
	}
}

var qb = new Object();

qb.removeQueryPart = function(divId) {
	var div = $(divId);
	if (div) {
		var parent = $(div.parentNode);
		if (parent) {
			var els = parent.getElementsByTagName('div');
			if (!els || els.length <= 2) {
				var count = 0
				for ( var i = 0; i < els.length; i++) {
					if (els[i].id && els[i].id.indexOf("__") == -1)
						count++;
				}
				if (count <= 1) {
					var nsList = parent.nextSiblings();
					if (nsList && nsList.length == 1) {
						if (nsList[0].tagName.toLowerCase() == 'div') {
							els = nsList[0].getElementsByTagName('div');
							var conCount = 0;
							for ( var i = 0; i < els.length; i++)
								if (els[i].id
										&& utils.strEndsWith(els[i].id,
												"__connector")) {
									orphan = els[i];
									conCount++;
								}
							if (conCount == 1)
								Element.remove(orphan);
						}
					}
					Element.remove(parent);
					return false;
				}
			}
			qb.handleOrphanConnector(divId, els);
		}
		Element.remove(divId);
	}
	return false;
}

qb.handleOrphanConnector = function(divId, els) {
	if (!els)
		return;
	// check for an orphan connector div and remove if so
	var hasOrphan = true;
	var divConnecterId = divId.replace(/__qp$/, '__connector');
	for ( var i = 0; i < els.length; i++) {
		if (els[i].id == divConnecterId) {
			hasOrphan = false;
			break;
		}
	}
	if (hasOrphan) {
		var orphan = null;
		for ( var i = 0; i < els.length; i++) {
			if (els[i].id && utils.strEndsWith(els[i].id, "__connector")) {
				orphan = els[i];
				break;
			}
		}
		if (orphan)
			Element.remove(orphan.id);
	}// hasOrphan
}
