/*--------------------------------------------------|
| dTree 2.05 | www.destroydrop.com/javascript/tree/ |
|---------------------------------------------------|
| Copyright (c) 2002-2003 Geir Landr�               |
|                                                   |
| This script can be used freely as long as all     |
| copyright messages are intact.                    |
|                                                   |
| Updated: 17.04.2003                               |
|--------------------------------------------------*/
/*
   I. Burak Ozyurt 6/6/2006
   Fixed very inefficient children and last sibling detection with O(1) algorithm
   using the assumption that nodes are added as depth-first manner, for very large
   trees. Upto four times better performance can be achieved this way.
   5/30/2007
   added checkbox support
   requires Prototype library   
*/


// Node object
function Node(id, pid, name, nodeType, payload, url, title, target, 
   icon, iconOpen, open, hasCB, cbSelected, toolTip) {
	this.id = id;
	this.pid = pid;
	this.name = name;
	this.url = url;
	this.title = title;
	this.target = target;
	this.icon = icon;
	this.iconOpen = iconOpen;
	this._io = open || false;
	this._is = false;
	this._ls = false;
	this._hc = false;
	this._ai = 0;
	this._p;
    // IBO
    this.hasCB = hasCB || true;
    this.hasCB = !(pid == -1);
    if ( this.hasCB) {
	   this.cbSelected = cbSelected || false;
	}
	this.toolTip = toolTip || null;
	this.nodeType = nodeType || 'none';
	this.payload = payload;
	this.children = null;
};


// works under the assumption that nodes are added as depth-first manner IBO
Node.prototype.addChild=function(childNode) {
   if (this.children == null) {
	   this.children = new Array();
   }
   this.children[this.children.length] = childNode;
}

// Tree object
function dTree(objName) {
	this.config = {
		target: null,
		folderLinks: true,
		useSelection: true,
		useCookies: true,
		useLines: true,
		useIcons: true,
		useStatusText: false,
		closeSameLevel: false,
		inOrder	: false,
                useCB : false
	}
	this.icon = {
		root: 'images/base.gif',
		folder: 'images/folder.gif',
		folderOpen: 'images/folderopen.gif',
		node: 'images/page.gif',
		empty: 'images/empty.gif',
		line: 'images/line.gif',
		join: 'images/join.gif',
		joinBottom: 'images/joinbottom.gif',
		plus: 'images/plus.gif',
		plusBottom: 'images/plusbottom.gif',
		minus: 'images/minus.gif',
		minusBottom: 'images/minusbottom.gif',
		nlPlus: 'images/nolines_plus.gif',
		nlMinus: 'images/nolines_minus.gif'
	};
	this.obj = objName;
	this.aNodes = [];
	this.aIndent = [];
	this.root = new Node(-1);
	this.selectedNode = null;
	this.selectedFound = false;
	this.completed = false;
	// IBO
	this.nodeIDMap = new Array();
	this.onCBListeners = new Array();
	this.clMap = new Array();
    this.uclMap = new Array();
};


// Adds a new node to the node array
dTree.prototype.add = function(id, pid, name, nodeType, payload, 
	url, title, target, icon, iconOpen, open, hasCB, cbSelected, toolTip) {
	// IBO
	var aNode = new Node(id, pid, name, nodeType, payload, url, title, target, 
	     icon, iconOpen, open, hasCB, cbSelected, toolTip);
	this.aNodes[this.aNodes.length] = aNode;
	this.nodeIDMap[ aNode.id ] = aNode;
	if (aNode.id == 0)  {
		aNode._hc = true;
	}
	var parentNode = this.nodeIDMap[ aNode.pid ];
	if (parentNode) {
		parentNode.addChild(aNode);
		parentNode._hc = true;
	}
};

function dtree_checkHandler(ev) {
   var cbElem = Event.element(ev);
   var nodeId = cbElem.id.substring(3 + this.obj.length );
   var node = this.aNodes[nodeId];

   //alert(this.obj + " " + cbElem + " nodeId:" + nodeId + " node:" + node + " checked:" + cbElem.checked);
   var checkedList = new Array();
   var uncheckedList = new Array();
   var payload = { tree: this.obj, payload: node.payload, hasChild: node._hc, id: node.id};
   var found = null;
   if ( cbElem.checked) {
       found = this.clMap[payload.id];
       if (!found) {
         checkedList.push(payload);
         this.clMap[payload.id] = 1;
         this.uclMap[payload.id] = 0;
       }
   } else {
      found = this.uclMap[payload.id];
      if (!found) {
        uncheckedList.push(payload);
        this.uclMap[payload.id] = 1;
        this.clMap[payload.id] = 0;        
      }
   }
   
   this.checkAllChildren(node,cbElem.checked, checkedList, uncheckedList);
   // alert("dtree_checkHandler: checkedList:" + checkedList.length);
   this.onCBStateChange(checkedList, uncheckedList);
}

dTree.prototype.checkAllChildren=function(node,checkIt, checkedList, uncheckedList) {
   for (var n=0; n < this.aNodes.length; n++) {
       if (this.aNodes[n].pid == node.id) {
	      var cbElem = $('cb_' + this.obj + n);
          if (cbElem) {
	        cbElem.checked = checkIt;
	        var payload = { tree: this.obj, payload: this.aNodes[n].payload,
	             hasChild: this.aNodes[n]._hc, id: this.aNodes[n].id};
            if ( cbElem.checked) {
                var found = this.clMap[payload.id];
                // alert(payload.id + " found:" + found);
                if (!found) {
                  checkedList.push(payload);
                  this.clMap[payload.id] = 1;
                  this.uclMap[payload.id] = 0;
                }
            } else {
                var found = this.uclMap[payload.id]
                if (!found) {
                  uncheckedList.push(payload);
                  this.uclMap[payload.id] = 1;
                  this.clMap[payload.id] = 0;
                }
            }         
	       this.checkAllChildren(this.aNodes[n],checkIt, checkedList, uncheckedList);
	    }    
       }
   }
}

dTree.prototype.setSelectedBySuffix=function(suffix) {
   var cbPrefix = 'cb_' + this.obj;
   var hrefPrefix = 's' + this.obj;
   for (var n=0; n < this.aNodes.length; n++) {
      if (this.aNodes[n].name.endsWith(suffix) ) {
	 var cbElem = $(cbPrefix + n);
	 if (cbElem) {
	    cbElem.checked = true;
	 }
      }
   }
}

dTree.prototype.getSelectedTitles=function() {
   var cbPrefix = 'cb_' + this.obj;
   var hrefPrefix = 's' + this.obj;
   var selTitles = new Array();
    for (var n=0; n < this.aNodes.length; n++) {
       if (!this.aNodes[n]._hc) {
	  var cbElem = $(cbPrefix + n);
          if (cbElem && cbElem.checked) {
             var path = this.buildPath(this.aNodes[n]);
             var nodeType = this.aNodes[n].nodeType;
             selTitles.push({ path : path, type : nodeType });	     	     
	  }
       }
    }
   return selTitles;
}

dTree.prototype.buildPath=function(node) {
   var stack = new Array();
   var n = node;
   while(n) {
      stack.push(n.name);
      n = this.nodeIDMap[ n.pid ];
   } 
   var s = "";
   var len = stack.length;
   for(var i = 0; i < len; i++) {
      s += stack.pop();
      if ( stack.length > 0) s+= "/";
   }
   return s;
}

// Open/close all nodes
dTree.prototype.openAll = function() {
	this.oAll(true);
};
dTree.prototype.closeAll = function() {
	this.oAll(false);
};

// Outputs the tree to the page
dTree.prototype.toString = function() {
	var str = '<div class="dtree">\n';
	if (document.getElementById) {
		if (this.config.useCookies) this.selectedNode = this.getSelected();
		str += this.addNode(this.root);
	} else str += 'Browser not supported.';
	str += '</div>';
	if (!this.selectedFound) this.selectedNode = null;
	this.completed = true;
	return str;
};


// uses O(1) algorithm instead of original O(n^2) IBO
dTree.prototype.addNode = function(pNode) {
	var str = '';
	var n=0;
	if (this.config.inOrder) n = pNode._ai;
	for (n; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == pNode.id) {
		   var cn = this.aNodes[n];
		   cn._p = pNode;
		   cn._ai = n;       	       
		   // IBO
		   var parentNode = this.nodeIDMap[ cn.pid ];
		   if (parentNode) {
			var lastChild = parentNode.children[ parentNode.children.length - 1]; 
			if ( lastChild.id == cn.id) {			
			   cn._ls = true;
			}
		   }
			
		   if (!cn.target && this.config.target) cn.target = this.config.target;
		   if (cn._hc && !cn._io && this.config.useCookies) cn._io = this.isOpen(cn.id);
		   if (!this.config.folderLinks && cn._hc) cn.url = null;
		   if (this.config.useSelection && cn.id == this.selectedNode && 
                             !this.selectedFound) 
		   {
			cn._is = true;
			this.selectedNode = n;
			this.selectedFound = true;
		   }
		   str += this.node(cn, n);
		   if (cn._ls) break;
		}
	}
	return str;
}


// Creates the node icon, url and text
dTree.prototype.node = function(node, nodeId) {
    var str = '<div class="dTreeNode">' + this.indent(node, nodeId);
    if (this.config.useIcons) {
	if (!node.icon) node.icon = (this.root.id == node.pid) ? this.icon.root : ((node._hc) ? this.icon.folder : this.icon.node);
	if (!node.iconOpen) node.iconOpen = (node._hc) ? this.icon.folderOpen : this.icon.node;
	if (this.root.id == node.pid) {
		node.icon = this.icon.root;
		node.iconOpen = this.icon.root;
	}
	str += '<img id="i' + this.obj + nodeId + '" src="' + 
	   ((node._io) ? node.iconOpen : node.icon) + '" alt="" />';
    }
    if (node.hasCB) {
       str += '<input type="checkbox" id="cb_' + this.obj + nodeId 
       + '" class="dtreeCB" ' + (node.cbSelected ? 'checked' : '') + '></input>';
    }
    if (node.url) {
	str += '<a id="s' + this.obj + nodeId + '" class="' + 
	  ((this.config.useSelection) ? ((node._is ? 'nodeSel' : 'node')) : 'node') 
	  + '" href="' + node.url + '"';
	if (node.title) str += ' title="' + node.title + '"';
	if (node.target) str += ' target="' + node.target + '"';
	if (this.config.useStatusText) str += ' onmouseover="window.status=\'' + node.name + '\';return true;" onmouseout="window.status=\'\';return true;" ';
	if (this.config.useSelection && ((node._hc && this.config.folderLinks) || !node._hc))
		str += ' onclick="javascript: ' + this.obj + '.s(' + nodeId + ');"';
	str += '>';
    } else if ((!this.config.folderLinks || !node.url) && node._hc && node.pid != this.root.id)
		str += '<a href="javascript: ' + this.obj + '.o(' + nodeId + ');" class="node">';
    if (node.toolTip) {
	  str += '<span title="' + node.toolTip + '">' + node.name + '</span>';
    } else {	
	  str += node.name;
    }
    if (node.url || ((!this.config.folderLinks || !node.url) && node._hc)) str += '</a>';
    str += '</div>';
    if (node._hc) {
	 str += '<div id="d' + this.obj + nodeId + '" class="clip" style="display:' + ((this.root.id == node.pid || node._io) ? 'block' : 'none') + ';">';
	 str += this.addNode(node);
	 str += '</div>';
    }
    this.aIndent.pop();
    return str;
};

// Adds the empty and line icons
dTree.prototype.indent = function(node, nodeId) {
   var str = '';
   if (this.root.id != node.pid) {
     for (var n=0; n<this.aIndent.length; n++) {	      
	str += '<img src="' 
	 + ( (this.aIndent[n] == 1 && this.config.useLines) ? this.icon.line : this.icon.empty ) + '" alt="" />';
	      
     }
     (node._ls) ? this.aIndent.push(0) : this.aIndent.push(1);
     if (node._hc) {
	 str += '<a href="javascript: ' + this.obj + '.o(' + nodeId + ');"><img id="j' + this.obj 
	        + nodeId + '" src="';
	 if (!this.config.useLines) str += (node._io) ? this.icon.nlMinus : this.icon.nlPlus;
	 else str += ( (node._io) ? ((node._ls && this.config.useLines) ? this.icon.minusBottom : this.icon.minus) : ((node._ls && this.config.useLines) ? this.icon.plusBottom : this.icon.plus ) );
	 str += '" alt="" /></a>';
     } else str += '<img src="' + ( (this.config.useLines) ? ((node._ls) ? this.icon.joinBottom : this.icon.join ) : this.icon.empty) + '" alt="" />';
   }
   return str;
};


// Returns the selected node
dTree.prototype.getSelected = function() {
	var sn = this.getCookie('cs' + this.obj);
	return (sn) ? sn : null;
};

// Highlights the selected node
dTree.prototype.s = function(id) {
   if (!this.config.useSelection) return;
   var cn = this.aNodes[id];
   if (cn._hc && !this.config.folderLinks) return;
   if (this.selectedNode != id) {
	if (this.selectedNode || this.selectedNode==0) {
	  eOld = document.getElementById("s" + this.obj + this.selectedNode);
	  eOld.className = "node";
	}
	eNew = document.getElementById("s" + this.obj + id);
	eNew.className = "nodeSel";
	this.selectedNode = id;
	if (this.config.useCookies) this.setCookie('cs' + this.obj, cn.id);
   }
};

//IBO
dTree.prototype.registerCBObservers=function() {
    for (var n=0; n<this.aNodes.length; n++) {
       if (this.aNodes[n] && this.aNodes[n].pid != this.root.id) {
          var cbElem = $('cb_' + this.obj + n);
          if (cbElem) {
             Event.observe(cbElem, 'click', dtree_checkHandler.bindAsEventListener(this) );	     
	  } 
       }
    }
}

//IBO
dTree.prototype.registerCBEventListener=function(lsnr) {
   this.onCBListeners[ this.onCBListeners.length ] = lsnr;
}

dTree.prototype.onCBStateChange=function(checkedList, uncheckedList) {
    if ( this.onCBListeners) {
       for(var i = 0; i < this.onCBListeners.length; ++i) {
          var fun = this.onCBListeners[i];
          if ( fun )
            fun.call(this, checkedList, uncheckedList);         
       }
    }
}

// Toggle Open or close
dTree.prototype.o = function(id) {
   var cn = this.aNodes[id];
   this.nodeStatus(!cn._io, id, cn._ls);
   cn._io = !cn._io;
   if (this.config.closeSameLevel) this.closeLevel(cn);
   if (this.config.useCookies) this.updateCookie();
};

// Open or close all nodes
dTree.prototype.oAll = function(status) {
  for (var n=0; n<this.aNodes.length; n++) {
     if (this.aNodes[n]._hc && this.aNodes[n].pid != this.root.id) {
	this.nodeStatus(status, n, this.aNodes[n]._ls)
	this.aNodes[n]._io = status;
     }
  }
  if (this.config.useCookies) this.updateCookie();
};

// Opens the tree to a specific node
dTree.prototype.openTo = function(nId, bSelect, bFirst) {
   if (!bFirst) {
	for (var n=0; n<this.aNodes.length; n++) {
 	   if (this.aNodes[n].id == nId) {
	     nId=n;
	     break;
	   }
	}
   }
   var cn=this.aNodes[nId];
   if (cn.pid==this.root.id || !cn._p) return;
   cn._io = true;
   cn._is = bSelect;
   if (this.completed && cn._hc) this.nodeStatus(true, cn._ai, cn._ls);
   if (this.completed && bSelect) this.s(cn._ai);
   else if (bSelect) this._sn=cn._ai;
   this.openTo(cn._p._ai, false, true);
};

// Closes all nodes on the same level as certain node
dTree.prototype.closeLevel = function(node) {
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.pid && this.aNodes[n].id != node.id && this.aNodes[n]._hc) {
			this.nodeStatus(false, n, this.aNodes[n]._ls);
			this.aNodes[n]._io = false;
			this.closeAllChildren(this.aNodes[n]);
		}
	}
}

// Closes all children of a node
dTree.prototype.closeAllChildren = function(node) {
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.id && this.aNodes[n]._hc) {
			if (this.aNodes[n]._io) this.nodeStatus(false, n, this.aNodes[n]._ls);
			this.aNodes[n]._io = false;
			this.closeAllChildren(this.aNodes[n]);		
		}
	}
}

// Change the status of a node(open or closed)
dTree.prototype.nodeStatus = function(status, id, bottom) {
	eDiv	= document.getElementById('d' + this.obj + id);
	eJoin	= document.getElementById('j' + this.obj + id);
	if (this.config.useIcons) {
		eIcon	= document.getElementById('i' + this.obj + id);
		eIcon.src = (status) ? this.aNodes[id].iconOpen : this.aNodes[id].icon;
	}
	eJoin.src = (this.config.useLines)?
	((status)?((bottom)?this.icon.minusBottom:this.icon.minus):((bottom)?this.icon.plusBottom:this.icon.plus)):
	((status)?this.icon.nlMinus:this.icon.nlPlus);
	eDiv.style.display = (status) ? 'block': 'none';
};


// [Cookie] Clears a cookie
dTree.prototype.clearCookie = function() {
	var now = new Date();
	var yesterday = new Date(now.getTime() - 1000 * 60 * 60 * 24);
	this.setCookie('co'+this.obj, 'cookieValue', yesterday);
	this.setCookie('cs'+this.obj, 'cookieValue', yesterday);
};

// [Cookie] Sets value in a cookie
dTree.prototype.setCookie = function(cookieName, cookieValue, expires, path, domain, secure) {
	document.cookie =
		escape(cookieName) + '=' + escape(cookieValue)
		+ (expires ? '; expires=' + expires.toGMTString() : '')
		+ (path ? '; path=' + path : '')
		+ (domain ? '; domain=' + domain : '')
		+ (secure ? '; secure' : '');
};

// [Cookie] Gets a value from a cookie
dTree.prototype.getCookie = function(cookieName) {
	var cookieValue = '';
	var posName = document.cookie.indexOf(escape(cookieName) + '=');
	if (posName != -1) {
		var posValue = posName + (escape(cookieName) + '=').length;
		var endPos = document.cookie.indexOf(';', posValue);
		if (endPos != -1) cookieValue = unescape(document.cookie.substring(posValue, endPos));
		else cookieValue = unescape(document.cookie.substring(posValue));
	}
	return (cookieValue);
};

// [Cookie] Returns ids of open nodes as a string
dTree.prototype.updateCookie = function() {
	var str = '';
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n]._io && this.aNodes[n].pid != this.root.id) {
			if (str) str += '.';
			str += this.aNodes[n].id;
		}
	}
	this.setCookie('co' + this.obj, str);
};

// [Cookie] Checks if a node id is in a cookie
dTree.prototype.isOpen = function(id) {
	var aOpen = this.getCookie('co' + this.obj).split('.');
	for (var n=0; n<aOpen.length; n++)
		if (aOpen[n] == id) return true;
	return false;
};

// If Push and pop is not implemented by the browser
if (!Array.prototype.push) {
       
	Array.prototype.push = function array_push() {
		for(var i=0;i<arguments.length;i++)
			this[this.length]=arguments[i];
		return this.length;
	}
} 

if (!Array.prototype.pop) {
	Array.prototype.pop = function array_pop() {
		lastElement = this[this.length-1];
		this.length = Math.max(this.length-1,0);
		return lastElement;
	}
};
