//
//  requires YUI panel and PEGS generated filter.js and jquery.cbfbirn.utils.js
//
;(function($, window,document, undefined) {
  var methods = {
     init : function(selComp, options) {
       var this$ = $(this),
            data = this$.data('recfilter'),
            settings = $.extend({
              filterBuilderPanelId:'filterBuilderPanel'
            }, options || {}),
            fbPanel;

       if (!data) {
          this$.data('recfilter', {settings:settings});
          data = this$.data('recfilter');
       }

       var ph = ($(window).height() * 7) / 10;
       ph = ph + "px";
       var fbPanel = new YAHOO.widget.Panel(settings.filterBuilderPanelId,                 
                {close:true, visible:false, modal:true, 
                autofillheight:"body", fixedcenter:true}); 

       fbPanel.render(); 
       settings.fbPanel = fbPanel;

       //fbPanel.hideEvent.subscribe( function(type,oArgs) {
       //    console.log('before hiding');
       //    this$.removeData('recfilter');
       //});

       function accumUnaryFunc(rec, funcName, filterVar, accumulator,useVisitId,filterVarSchema) {
         var val, key = useVisitId ? rec.subjectID + ':' + rec.visitID : rec.subjectID, 
                  curVal = accumulator[key];         
         val = rec[filterVar];
         if (!curVal) {
            accumulator[key] = val;   
         } else {
            var type = filterVarSchema[filterVar];
            accumulator[key] = unaryInnerFun(val, curVal,type, funcName);  
         }
       }

       function unaryFunc(rec, funcName, filterVar, accumulator,useVisitId) {
          var val, key = useVisitId ? rec.subjectID + ':' + rec.visitID : rec.subjectID, 
            accumVal = accumulator[key];
          if (!accumVal) return false;
          val = rec[filterVar];
          return accumVal == val;
       }

       function unaryInnerFun(val, prevVal, type, funName,useVisitId) {
           if (type === "int") {
               var pv = parseInt(prevVal);
               var v = parseInt(val);
               if (funName === 'max' || funName === 'maxInVisit') 
                    return Math.max(pv,v);
               else if (funName === 'min' || funName === 'minInVisit')
                    return Math.min(pv,v);
               else 
                  return v;
           } else if (type === "date") {
               var d1 = new Date(prevVal);
               var d2 = new Date(val);
               if (funName === 'max' || funName === 'maxInVisit') 
                  return d1.getTime() < d2.getTime() ? val : prevVal;
               else if (funName === 'min' ||  funName === 'minInVisit')
                  return d1.getTime() > d2.getTime() ? val : prevVal;
               else 
                  return val;
           } else if (type === "string") {
               if( funName === 'max' ||  funName === 'maxInVisit') 
                 return val > prevVal ? val : prevVal;
               else if (funName === 'min' ||  funName === 'minInVisit') 
                 return val > prevVal ? prevVal : val;
               else 
                 return val;
           }
           return val;
       }

       function accumHasAll(rec, filterVar,rightVal, accumulator) {
           var i, val, matchedOnes = accumulator[rec.subjectID];
           if (!matchedOnes) {
              matchedOnes = [];
              accumulator[rec.subjectID] = matchedOnes;
           }
           val = rec[filterVar];
           for(i = 0; i < rightVal.length; i++) {
              if (val == rightVal[i]) {
                  matchedOnes.push(val);
                  break;
              }
           } 
       }

       function hasAll(rec, filterVar, rightVal, accumulator) {
         var i, val, matchedOnes = accumulator[rec.subjectID];
         if (!matchedOnes) return false;
         if (matchedOnes.length != rightVal.length) return false;
         val = rec[filterVar];
         for(i = 0; i < rightVal.length; i++) {
            if (val == rightVal[i]) {
                return true;
            }
         }
         return false;
       }

       function compPred(rec, filterVar, rightVal, op, filterVarSchema) {
          var val = rec[filterVar];
          var type = filterVarSchema[filterVar];
          if (!val || !type) return false;
          if (type === "string") {
             if (op === "startsWith") return val.indexOf(rightVal) === 0;
             else if (op === "endsWith") 
                return val.indexOf(rightVal, val.length - rightVal.length) !== -1;
             else if (op === "contains") 
                return val.indexOf(rightVal) !== -1;
             else if (op === "=")
                return val === rightVal;
             else if (op === "!=")
                return val !== rightVal;
          } else if (type === "int") {
            var rv = parseInt(rightVal);
            var v = parseInt(val);
            if (op === '=') return v === rv;
            else if (op === '>') return v > rv;
            else if (op === '<') return v < rv;
            else if (op === '<=') return v <= rv;
            else if (op === '>=') return v >= rv;
            else if (op === '!=') return v != rv;
          } else if (type === 'date') {
             var d1 = new Date(val);
             var d2 = new Date(rightVal);
             if (op === '=') return d1.getTime() === d2.getTime();
             else if (op === '<') return d1.getTime() < d2.getTime();
             else if (op === '>') return d1.getTime() > d2.getTime();
             else if (op === '>=') return d1.getTime() >= d2.getTime();
             else if (op === '<=') return d1.getTime() <= d2.getTime();
             else if (op === '!=') return d1.getTime() != d2.getTime();
          }
          return false;
       }
      
       var accumFunMap = {
         "hasAll" : accumHasAll,
         "max" : accumUnaryFunc,
         "min" : accumUnaryFunc,
         "maxInVisit" : accumUnaryFunc,
         "minInVisit" : accumUnaryFunc
       };

       var funMap = {
         "hasAll" : hasAll,
         "=" : function(r,f,rv,fvs) { return compPred(r,f,rv,'=',fvs); },
         ">" : function(r,f,rv,fvs) { return compPred(r,f,rv,'>', fvs); },
         "<" : function(r,f,rv,fvs) { return compPred(r,f,rv,'<', fvs); },
         ">=" : function(r,f,rv,fvs) { return compPred(r,f,rv,'>=', fvs); },
         "<=" : function(r,f,rv,fvs) { return compPred(r,f,rv,'<=', fvs); },
         "!=" : function(r,f,rv,fvs) { return compPred(r,f,rv,'!=', fvs); },
         "startsWith" : function(r,f,rv,fvs) { return compPred(r,f,rv,'startsWith',fvs); },
         "endsWith" : function(r,f,rv,fvs) { return compPred(r,f,rv,'endsWith',fvs); },
         "contains" : function(r,f,rv,fvs) { return compPred(r,f,rv,'contains',fvs); },
         "max" : unaryFunc,
         "min" : unaryFunc,
         "maxInVisit" : unaryFunc,
         "minInVisit" : unaryFunc,
       };

       function applyFilter(recs, pif, filterVarSchema) {
          var rec,i,accumMap = {}, beArr = [], result = { val:false };
          collectBE(pif,beArr);
          for(i = 0; i < recs.length; i++) {
             applyFilter2RecFirstPass(recs[i], pif, accumMap,beArr, filterVarSchema);
          }
          // second pass for actual filtering
          var finalRecs = [];
          for(i = 0; i < recs.length; i++) {
             applyFilter2Rec(recs[i], pif, accumMap, result, filterVarSchema);
             if (!result.val) {
               //  console.log("filtering out rec:" , recs[i]);
             } else {
                finalRecs.push(recs[i]);
             }
          }
          return finalRecs;
       }

       function checkSemantics(pif, varSchema) {
         var errMsg = {msg:""}; 
         if (!pif) return errMsg;
         (function csFun(p, err) {
            if (!p) return;
            if (p.type === 'BinaryExpression') {
               if (!varSchema[p.left]) {
                   if (err.msg.length > 0) err.msg += "\n";
                   err.msg += "not a valid variable '" + p.param + "' in expression '" 
                      + p.left + + " " + p.operator + " " + p.right + "'!"; 
               }
            } else if (p.type === 'Predicate') {
                if (!varSchema[p.param]) {
                   if (err.msg.length > 0) err.msg += "\n";
                   err.msg += "not a valid variable '" + p.param + "' for function '" + p.name + "'!"; 
                }
            } else {
                csFun(p.left, err);
                csFun(p.right, err);
            }
         })(pif,errMsg);
         return errMsg.msg;
       }

       function applyFilter2Rec(rec, pif, accumMap, result, filterVarSchema) {
         if (!pif) return;
         if (pif.type === "LogicalExpression") {
              var leftResult, rightResult;
              if (pif.left.type === "BinaryExpression" || 
                pif.left.type === "Predicate") {
                  leftResult = applyPredicate(rec, pif.left, accumMap, filterVarSchema);
              } else {
                  var r = { val:false };
                  applyFilter2Rec(rec, pif.left, accumMap, r, filterVarSchema);
                  leftResult = r.val;
              }

              if (pif.right.type === "BinaryExpression" || 
                 pif.left.type === "Predicate") {
                  rightResult = applyPredicate(rec, pif.right, accumMap, filterVarSchema);
              } else {
                  var r = { val:false };
                  applyFilter2Rec(rec, pif.right, accumMap, r, filterVarSchema);
                  rightResult = r.val;
              }
              if (pif.operator === "or") {
                 result.val = leftResult || rightResult;
               } else {
                 result.val = leftResult && rightResult;
              }
         } else if (pif.type === "BinaryExpression" || pif.type === "Predicate") {
             result.val = applyPredicate(rec, pif, accumMap, filterVarSchema);
         }
       }

       function applyPredicate(rec, p, accumMap, filterVarSchema) {
          var funName = p.operator ? p.operator : p.name;
          var f = funMap[funName];
          if (needsAccumulator(funName)) {
             var key = p.type === "Predicate" ?  
                  p.name + ":" + p.param : p.operator + ":" + p.right + ":" + p.left;
             var accum = accumMap[key];
             if (p.type === "Predicate") { 
                var useVisitId = funName === 'maxInVisit' || funName === 'minInVisit';
                return f(rec, p.name, p.param, accum, useVisitId);
             } else   
                return f(rec,p.left, p.right, accum);        
          } else {
             return f(rec, p.left, p.right, filterVarSchema);
          }
       }

       function applyFilter2RecFirstPass(rec, pif, accumMap, beArr, filterVarSchema) {
          var be,i;
          for(i = 0; i < beArr.length; i++) {
             be = beArr[i];
             var funName = be.operator ? be.operator : be.name;
             var f = accumFunMap[funName];
             if (needsAccumulator(funName)) {
                var key = be.type === "Predicate" ?  
                  be.name + ":" + be.param : be.operator + ":" + be.right + ":" + be.left;
                var accum = accumMap[key];
                if (!accum) {
                  accum = {};
                  accumMap[key] = accum;
                }
                if (be.type === "Predicate") {
                   var useVisitId = funName === 'maxInVisit' || funName === 'minInVisit';
                   f(rec, be.name, be.param, accum, useVisitId, filterVarSchema);
                } else   
                   f(rec,be.left, be.right, accum);
             } 
          }
       }

       function needsAccumulator(funName) {
          return funName === "hasAll" || funName.indexOf("max") === 0 || funName.indexOf("min") === 0;  
       }

       function collectBE(pif, beArr) {
         if (!pif) return;
         if (pif.type === "BinaryExpression" || pif.type === "Predicate") {
             beArr.push(pif);
         } else {
            if (pif.left) 
              collectBE(pif.left, beArr);
            if (pif.right) 
               collectBE(pif.right, beArr);
         }
       }

       function recGenFun(idx, value, optText, title) {
         var valToks = value.split(':');
         var textToks = optText.split(' - ');
         var rec = {
           idx: idx,
           subjectID: valToks[1],
           jobID: valToks[0],
           visitID: valToks[2],
           project: valToks[3],
           jobTag: textToks[1],
           value: value,
           text: optText,
           title: title 
         };
         var toks = textToks[2].split(' ');
         rec.visitDate = toks[1];
         return rec;
       }

      var buildFB = function(recs, filterVarSchema, cbFun) {
          var fbp$ = $('#filterBuilderPanel');
          $('.parseResults', fbp$).hide();
          $('.saveFilterPanel',fbp$).hide();   
          $('#savedFiltersPanel',fbp$).hide();   
          if (settings.url && settings.getFilterAction) {
               $.ajax({url:settings.url, 
                  data:{action:'getJobFilters'} ,
                  success: function(response) {
                    if (response && response.length > 0) {
                       $.populateSelect($('#savedFilterSel',fbp$)[0],response,
                        function(o) { 
                          var title = o.name ? "[" + o.name + "]" : "";
                          if (title.length > 0) title += " ";
                          title += o.desc ? o.desc : "";
                          return {name:o.filter, value:o.filter, title: title};}
                        );
                        $('#savedFiltersPanel',fbp$).show();   
                        $('#useSavedFilterBut',fbp$).unbind('click').click(
                          function(evt) {
                            $('#filterInput',fbp$).attr('value',
                              $(':selected',$('#savedFilterSel',fbp$)).val() );  
                        });
                        $('#savedFilterSel', fbp$).unbind('change').bind('change', 
                         function(evt) {
                             var title = $(':selected',this).data('title');
                             if (title) {
                                 $('#filterTitle',fbp$).text(title);
                             }
                         });
                         $('#savedFilterSel', fbp$).trigger('change');
                    }
                  }, dataType:'json', async:false} );
          }
          
          var vars = [];
          $.each(filterVarSchema, function(key,value) {
                vars.push(key); });
          $.populateSelect(jQuery('#fbVarSel',fbp$)[0], vars, function(o) {
               return { name:o, value:o }; });
          $.populateSelect(jQuery('#fbFunSel',fbp$)[0], ["=",">",">=","<","<=","!=",
                "hasAll","contains","startsWith", "endsWith","and","or", 
                "max","min","maxInVisit","minInVisit"],
                function(o) { return { name:o, value:o }; });
          $('#addVarBut',fbp$).unbind('click').click(function(evt) {
              var val = $(':selected',$('#fbVarSel',fbp$)).val();
              var fi$ = $('#filterInput',fbp$);
              $(fi$).attr('value', $(fi$).attr('value') + val + " ");
          });
          $('#addOpBut',fbp$).unbind('click').click(function(evt) {
              var val = $(':selected',$('#fbFunSel',fbp$)).val();
              var fi$ = $('#filterInput',fbp$);
              if (val.indexOf("max") === 0 || val.indexOf("min") === 0) {
                $(fi$).attr('value',jQuery(fi$).attr('value') + val + "(");
              } else {
                $(fi$).attr('value',jQuery(fi$).attr('value') + val + " ");
              } 
          });
          $.populateSelect($("#filterPreview",fbp$)[0], recs,
            function(o) { return {name: o.text, value:o.value}; } );

          var showError = function(msg) {
              var d$ = $('.parseResults', fbp$);
              $('p',d$).text(msg.replace('\n','<br></br>')).css({color:"red", padding:"2px"});
              $(d$).show("fast");
          };

          var updateFilterSelInfo = function() {
               var el$ = jQuery('#filterSelInfo');
               var size = jQuery('option','#filterPreview').size();
               el$.text(size + " selected.");
          };
          updateFilterSelInfo();
          $('#runFilterBut',fbp$).unbind('click').click(function() {
             var r, prd$, filteredRecs,errMsg;
             try {
                r = PEG.parse($('#filterInput',fbp$).attr('value'));
                errMsg = checkSemantics(r,filterVarSchema);
                if (errMsg.length > 0) {
                   showError(errMsg);
                } else {
                  filteredRecs = applyFilter(recs, r, filterVarSchema);
                  $.populateSelect($("#filterPreview",fbp$)[0], filteredRecs,
                    function(o) { return {name: o.text, value:o.value}; } );
                  prd$ = $('.parseResults', fbp$);
                  $('p',prd$).text("Filter applied.").css({color:'green', padding:'2px'}).parent().show("fast");
                  updateFilterSelInfo();
                }
             } catch(e) {
                console.log(e);
                if (e.message) showError(e.message);
             }
          });
          $("#resetBut",fbp$).unbind('click').click(function() {
                $.populateSelect($("#filterPreview",fbp$)[0], recs,
                  function(o) { return {name: o.text, value:o.value}; } );
                $('.parseResults', fbp$).hide('fast');
             $('.saveFilterPanel',fbp$).hide('fast');
          });

          $("#showSaveFilterBut").unbind('click').click(function() {
             var fv = $('#filterInput',fbp$).attr('value');
             if (fv.length > 1) { 
                $('.saveFilterPanel',fbp$).show('slow');
                $('#filterExpr',fbp$).attr('value',fv);
             }
          });
          $("#filterAndCloseBut").unbind('click').click(function() {
              if (selComp) {
                var r, filteredRecs, errMsg;
                try {
                  r = PEG.parse($('#filterInput',fbp$).attr('value'));
                  errMsg = checkSemantics(r,filterVarSchema);
                  if (errMsg.length > 0) {
                    showError(errMsg);
                  } else {
                    filteredRecs = applyFilter(recs, r, filterVarSchema);
                    $.populateSelect($(selComp)[0], filteredRecs,
                       function(o) { return {name: o.text, value:o.value}; } );
                    fbPanel.hide(); 
                    if (cbFun) { cbFun(); }
                  }
                } catch(e) {
                  console.log(e);
                  if (e.message) showError(e.message);
                }
              }  
          });
          return fbp$;
       };

       settings.buildFB = buildFB;
       return this;
     },

     destroy : function() {
        $(this).removeData('recfilter');
        return this;
     },

     filter : function(recs,filterVarSchema, cbFun) {
         if (!recs || !filterVarSchema) return;
         var data = $(this).data('recfilter'),
             settings = data.settings,
             fbPanel = settings.fbPanel;
         $("#filterInput").attr('value','');
         settings.buildFB(recs, filterVarSchema, cbFun);
         fbPanel.setHeader("Filter Selected Jobs");
         fbPanel.show();
         return this;
     },

  };
  $.fn.recfilter = function(method) {
     if (methods[method]) {
        return methods[method].apply(this, Array.prototype.slice.call(arguments,1));
     } else if (typeof method === 'object' || !method) {
       return methods.init.apply(this,arguments);
     } else {
        $.error('Method ' + method + ' does not exists on jquery.cbfbirn.recfilter!');
     }
  };
})(jQuery, window,document);
