
Console=function(el) {
  this.el = document.getElementById(el);
  if (this.el) {
    this.el.className = 'console';
    this.el.consoleModel = this;
    this.clear();
  }
}

Console.prototype.append=function(obj, style) {
  if (!this.el) return;
  var domElem = Console.toDOMElement(obj);
  if ( style ) {
    domElem.className=style;
  }
  this.el.appendChild(domElem);
}

Console.prototype.clear=function() {
   if (!this.el) return;
   while(this.el.firstChild) {
      this.el.removeChild(this.el.firstChild);
   }
}

Console.toDOMElement=function(obj) {
   var elem = null;
   if ( typeof(obj) === 'element') {
       elem = obj;
   } else {
      var txtNode = document.createTextNode( String(obj) );
      var wrapper = document.createElement('div');
      wrapper.appendChild(txtNode);
      elem = wrapper;
   }
   return elem;
}

