var qbuilder = {};

//
// options 
//     allowExpOnlyQuery - if true filtering can be done by experiment only without any search filter
//
qbuilder.QueryBuilder = function(caMeta, provMeta, derivedMeta, expList,
		options) {
	this.caMeta = caMeta;
	this.provMeta = provMeta;
	this.derivedMeta = derivedMeta;
	this.expList = expList;
	this.filterCount = 0;
	this.options = options || {};
	jQuery('button.sfRemover').live('click', function() {
		var container = jQuery(this).closest('div.filterItem');
		var prevFilters = jQuery(container).prev("div.filterItem");
		if (prevFilters.size() > 0) {
			if (jQuery(container).next().size() === 0) {
				jQuery('.connective', prevFilters.last()).remove();
			}
		}
		container.remove();
	});
	jQuery('.filterItem [name]').live('suffixName', function() {
		var wr = jQuery(this);
		var suffix = wr.closest('.filterItem').data('suffix');
		if (/\w+\.\d+$/.test(wr.attr('name'))) {
			return;
		}
		wr.attr('name', wr.attr('name') + suffix);
	});
	if (this.expList !== null) {
		var selEl$ = jQuery("#searchExpSel");
		var selSize = selEl$.attr('size');
		if (this.expList.length < selSize) {
			selEl$.attr('size', this.expList.length > 0 ? this.expList.length
					: 1);
		}
		this.populateSelect(selEl$[0], this.expList, function(o) {
			return {
				name : o.name,
				value : o.id
			};
		});
	}
	var optValues = [];
	if (this.caMeta === null) {
		optValues.push('assessment');
	}
	if (this.provMeta === null) {
		optValues.push('provenance');
	}
	if (this.derivedMeta === null) {
		optValues.push('derived');
	}
	if (optValues.length > 0) {
		var stFilter = jQuery("select.filterChooser")[0];
		jQuery.filterOptions(stFilter, optValues);
	}
};

qbuilder.QueryBuilder.prototype.populateSearchItem = function(searchItemType,
		container) {
	var containerWr = jQuery(container);
	jQuery('div.template.sfRemover').children().clone().appendTo(containerWr);
	containerWr.data('suffix', '.' + this.filterCount++);
	var selEl = jQuery('<select></select>').appendTo(container)[0];
	// alert("searchItemType:" + searchItemType);
	if (this.caMeta && searchItemType == 'assessment') {
		jQuery(selEl).attr('name', 'assessment').css('width', '180px');
		this.populateSelect(selEl, this.caMeta, function(o) {
			return {
				name : o.name,
				value : o.asId
			};
		});
		var scoreSelEl = jQuery('<select></select>')[0];
		jQuery(scoreSelEl).appendTo(container).attr('name', 'score').css(
				'width', '100px');

		jQuery(selEl).live('change', this, function(event) {
			var selOpt = jQuery(':selected', this);
			var selAsId = selOpt.val();
			var as = jQuery.grep(event.data.caMeta, function(o) {
				return o.asId == selAsId;
			})[0];
			event.data.populateSelect(scoreSelEl, as.scores, function(o) {
				return {
					name : o.name,
					value : o.name,
					data : o.type
				};
			});
         jQuery(scoreSelEl).trigger('change');
		});

		jQuery(scoreSelEl).live('change', this, function(event) {
			var selOpt = jQuery(':selected', this);
			var scoreType = selOpt.data('ctx');
			var scoreName = selOpt.val();
			// alert("scoreType:" + scoreType);
			var filterItem = jQuery(this).closest('.filterItem');
			var asId = jQuery(':selected', jQuery(selEl)).val();
			event.data.prepQueryPart(filterItem, scoreName, scoreType, asId);
		});
      jQuery(selEl).trigger('change');

	} else if (this.provMeta !== null && searchItemType == 'provenance') {
		jQuery(selEl).attr('name', 'provenance');
		this.populateSelect(selEl, this.provMeta.params, function(o) {
			return {
				name : o.name,
				value : o.name,
				data : o.type
			};
		});
		jQuery(selEl).live('change', this, function(event) {
			var selOpt = jQuery(':selected', this);
			var varName = selOpt.val();
			var varType = selOpt.data('ctx');
			var filterItem = jQuery(this).closest('.filterItem');
			event.data.prepQueryPart(filterItem, varName, varType);
		}).trigger('change');
	} else if (this.derivedMeta !== null && searchItemType == 'derived') {
		jQuery(selEl).attr('name', 'derived');
		this.populateSelect(selEl, this.derivedMeta, function(o) {
			return {
				name : o.name,
				value : o.name
			};
		});
		var groupSel = jQuery('<select>').attr('name', 'varGroup').appendTo(
				container)[0];
		var varSel = jQuery('<select>').attr('name', 'resultVars').appendTo(
				container)[0];

		jQuery(selEl).bind('change', this, function(event) {
			var resultGroupName = jQuery(':selected', this).val();
			var filterItem = jQuery(this).closest('.filterItem');
			var ugnArr = event.data.getUniqueGroupNames(resultGroupName);
			event.data.populateSelect(groupSel, ugnArr, function(o) {
				return {
					name : o,
					value : o
				};
			});
			jQuery(groupSel).trigger('change');
		});
		jQuery(groupSel).bind('change', this, function(event) {
			var vgName = jQuery(':selected', this).val();
			var rgName = jQuery(':selected', selEl).val();
			var filterItem = jQuery(this).closest('.filterItem');
			var rg = jQuery.grep(event.data.derivedMeta, function(o) {
				return o.name == rgName;
			})[0];
			var rtArr = jQuery.grep(rg.resultTypes, function(o) {
				return o.group == vgName;
			});
			event.data.populateSelect(varSel, rtArr, function(o) {
				return {
					name : o.name,
					value : o.name,
					data : o.type
				};
			});
			jQuery(varSel).trigger('change');
		});
		jQuery(varSel).bind('change', this, function(event) {
			var varSelOpt = jQuery(':selected', this);
			var vgName = jQuery(':selected', groupSel).val();
			var rgName = jQuery(':selected', selEl).val();
			var varName = varSelOpt.val();
			var varType = varSelOpt.data('ctx');
			var filterItem = jQuery(this).closest('.filterItem');
			event.data.prepQueryPart(filterItem, varName, varType);
		});
		jQuery(selEl).trigger('change');
	}
	containerWr.children().trigger('suffixName');
};

qbuilder.QueryBuilder.prototype.populateGroupSelector = function(selRGName,
		container) {
	var uniqueGroupNames = this.getUniqueGroupNames(selRGName);
	var selEl = jQuery('<select>').attr('name', 'varGroup').appendTo(container)[0];
	this.populateSelect(selEl, uniqueGroupNames, function(o) {
		return {
			name : o,
			value : o
		};
	});
	jQuery(selEl).live('change', this, function(event) {
		var selGroup = jQuery(':selected', this).val();
		var groupVars = jQuery.grep(rgObj.resultTypes, function(o) {
			return o.group == selGroup;
		});
		var filterItem = jQuery(this).closest('.filterItem');
	});
};

qbuilder.QueryBuilder.prototype.getUniqueGroupNames = function(selRGName) {
	var rgObj = jQuery.grep(this.derivedMeta, function(o) {
		return o.name == selRGName;
	})[0];
	var groupNames = jQuery.map(rgObj.resultTypes, function(o) {
		return o.group;
	});
	groupNames.sort();
	var uniqueGroupNames = [];
	var len = groupNames.length;
	for ( var i = 0; i < len; i++) {
		if (i === 0 || groupNames[i - 1] != groupNames[i]) {
			uniqueGroupNames.push(groupNames[i]);
		}
	}
	return uniqueGroupNames;
};

qbuilder.QueryBuilder.prototype.populateSelect = function(selectEl, dataArr,
		optionGenFun) {
	jQuery('option', selectEl).remove();
	if (selectEl.options === null || selectEl.options.length === 0) {
		var selIdx = 0;
		for ( var i = 0; i < dataArr.length; i++) {
			var data = dataArr[i];
			var od = optionGenFun(data);
			var option = new Option(od.name, od.value);
			if (od.data) {
				jQuery(option).data('ctx', od.data);
			}
			if (i === 0) {
				option.selected = true;
				selIdx = i;
			}
			try {
				selectEl.add(option, null);
			} catch (e) {
				selectEl.add(option, -1);
			}
		}
	}
};

qbuilder.QueryBuilder.prototype.prepQueryPart = function(container, varName,
		varType, asId) {
	var con$, operatorSel;
	var theCon$ = jQuery(".connective", container).detach();
	jQuery('.qualifier', container).remove();
	if (varType == 'varchar' || varType == 'STRING') {
		jQuery('div.template.stringMatch').children().clone().addClass(
				'qualifier').appendTo(container);
		if (asId) {
			if (this.options.distinctScoreOpts && this.options.distinctScoreOpts.url) {
				var url = this.options.distinctScoreOpts.url;
				var action = this.options.distinctScoreOpts.action;
				var suffix = jQuery(container).data('suffix');
				jQuery('<div></div>').addClass('qualifier autocomplete').attr(
						'id', 'autoComplete' + suffix).appendTo(container);
				var textId = 'term' + suffix;
				jQuery('input[name^="term"]', container).attr('id', textId);
				jQuery.get(url, {action: action, scoreName: varName, asID: asId},
				    function(response, status) {
					    if (status == 'success') {
					    	new Autocompleter.Local(textId, 'autoComplete' + suffix, response.posVals, 
					    			{minChars : 0});    	
					    }
				    }, 'json');
			}
		} else {
          if (this.options.distinctProvParValueOpts && this.options.distinctProvParValueOpts.url) {
              var url = this.options.distinctProvParValueOpts.url;
              var action = this.options.distinctProvParValueOpts.action;
				  var suffix = jQuery(container).data('suffix');
				  jQuery('<div></div>').addClass('qualifier autocomplete').attr(
						'id', 'autoComplete' + suffix).appendTo(container);
				  var textId = 'term' + suffix;
				  jQuery('input[name^="term"]', container).attr('id', textId);
				  jQuery.get(url, {action: action, provName: varName},
				    function(response, status) {
					    if (status == 'success') {
					    	new Autocompleter.Local(textId, 'autoComplete' + suffix, response.posVals, 
					    			{minChars : 0});    	
					    }
				    }, 'json');
          }
      }
	} else if (varType == 'integer' || varType == 'INT' || varType == 'REAL'
			|| varType == 'FLOAT') {
		jQuery('div.template.numericMatch').children().clone().addClass(
				'qualifier').appendTo(container);
		operatorSel = jQuery("select.qualifier", container);
		operatorSel.bind('change', this, function(event) {
			var selectedOp = jQuery(':selected', this).text();
			// alert("selectedOp:"+ selectedOp);
			var filterItem = jQuery(this).closest('.filterItem');
			if (selectedOp == 'between') {
				con$ = jQuery(".connective", filterItem).detach();
				jQuery("input[name]", filterItem).remove();
				jQuery('div.template.numberRange').children().clone().addClass(
						'qualifier between').appendTo(filterItem).trigger(
						'suffixName');
				if (con$)
					filterItem.append(con$);
			} else {
				var ws = jQuery(".between", filterItem);
				if (ws.size() > 0) {
					ws.remove();
					con$ = jQuery(".connective", filterItem).detach();
					jQuery('div.template.numericMatch input[name]').clone()
							.addClass('qualifier').appendTo(filterItem)
							.trigger('suffixName');
					if (con$) {
						filterItem.append(con$);
					}
				}
			}
		});
	} else if (varType == 'BOOL' || varType == 'boolean') {
		jQuery('div.template.boolean').children().clone().addClass('qualifier')
				.appendTo(container);
	} else if (varType == 'DATE') {
		jQuery('div.template.dateMatch').children().clone().addClass(
				'qualifier').appendTo(container);
		jQuery('input[name^="dateTermBut"]', container).bind(
				'click',
				function(event) {
					var textEl = jQuery(this).prev().filter(
							'input[name^="dateTerm"]')[0];
					popUpCalendar(this, textEl, "mm/dd/yyyy");
				});
		operatorSel = jQuery("select.qualifier", container);
		operatorSel.bind('change', this, function(event) {
			var selectedOp = jQuery(':selected', this).text();
			var filterItem = jQuery(this).closest('.filterItem');
			if (selectedOp == 'between') {
				jQuery("input[name]", filterItem).remove();
				con$ = jQuery(".connective", filterItem).detach();
				jQuery('div.template.dateRange').children().clone().addClass(
						'qualifier between').appendTo(filterItem).trigger(
						'suffixName');
				if (con$)
					filterItem.append(con$);
				jQuery('input[name^="dateRange1But"]', filterItem).bind(
						'click',
						function(event) {
							var textEl = jQuery(this).prev().filter(
									'input[name^="dateRange1"]')[0];
							popUpCalendar(this, textEl, "mm/dd/yyyy");
						});
				jQuery('input[name^="dateRange2But"]', filterItem).bind(
						'click',
						function(event) {
							var textEl = jQuery(this).prev().filter(
									'input[name^="dateRange2"]')[0];
							popUpCalendar(this, textEl, "mm/dd/yyyy");
						});
			} else {
				var ws = jQuery(".between", filterItem);
				if (ws.size() > 0) {
					con$ = jQuery(".connective", filterItem).detach();
					ws.remove();
					jQuery('div.template.dateMatch input[name]').clone()
							.addClass('qualifier').appendTo(filterItem)
							.trigger('suffixName');
					if (con$)
						filterItem.append(con$);
					jQuery('input[name^="dateTermBut"]', filterItem).bind(
							'click',
							function(event) {
								var textEl = jQuery(this).prev().filter(
										'input[name^="dateTerm"]')[0];
								popUpCalendar(this, textEl, "mm/dd/yyyy");
							});
				}
			}
		});
	}
	if (theCon$)
		container.append(theCon$);
	if (jQuery("#searchPane .filterItem").size() > 1) {
		var prevFilter = jQuery(container).prev().last();
		if (jQuery(".connective", prevFilter).size() === 0)
			jQuery("div.template.connective").children().clone().addClass(
					'qualifier connective').appendTo(prevFilter);
	}
};

qbuilder.QueryBuilder.prototype.validateQP = function(cwr, type, varName) {
	var errMsg = '', rhs, op, lb, ub, bothValid, msg;
	if (type == 'integer' || type == 'INT' || type == 'REAL' || type == 'FLOAT') {
		op = jQuery("select[name^='numericMatchType']", cwr).val();
		if (op == 7) {
			lb = jQuery("input[name^='numberRange1']", cwr).val();
			ub = jQuery("input[name^='numberRange2']", cwr).val();
			bothValid = true;
			if (!jQuery.isValidNumeric(lb, type)) {
				errMsg += "Invalid lower bound value of '" + lb + "' for "
						+ varName + "!\n";
				bothValid = false;
			}
			if (!jQuery.isValidNumeric(ub, type)) {
				errMsg += "Invalid upper bound value of '" + ub + "' for "
						+ varName + "!\n";
				bothValid = false;
			}
			if (bothValid) {
				msg = jQuery.checkNumberRange(lb, ub);
				if (msg.length > 0) {
					errMsg += "Invalid range for '" + varName + "':" + msg
							+ "\n";
				}
			}
		} else {
			rhs = jQuery("input[name^='term']", cwr).val();
			if (!jQuery.isValidNumeric(rhs, type))
				errMsg += "Invalid value of '" + rhs + "' for " + varName
						+ "!\n";
		}
	} else if (type == 'varchar' || type == 'STRING') {
		rhs = jQuery("input[name^='term']", cwr).val();
		rhs = jQuery.trim(rhs);
		if (rhs.length === 0) {
			errMsg += "A nonempty value is expected for " + varName + "!\n";
		}
	} else if (type == 'BOOL') {
		var checkedSize = jQuery("input[name^='booleanFilter']:checked", cwr)
				.size();
		if (checkedSize === 0) {
			errMsg += "No option is selected for " + varName + "!\n";
		}
	} else if (type == 'DATE') {
		op = jQuery("select[name^='dateMatchType']", cwr).val();
		if (op == 7) {
			lb = jQuery("input[name^='dateRange1']", cwr).val();
			ub = jQuery("input[name^='dateRange2']", cwr).val();
			bothValid = true;
			if (!jQuery.isValidDate(lb)) {
				errMsg += "Invalid lower bound date value of '" + lb + "' for "
						+ varName + "!\n";
				bothValid = false;
			}
			if (!jQuery.isValidDate(ub)) {
				errMsg += "Invalid upper bound date value of '" + ub + "' for "
						+ varName + "!\n";
				bothValid = false;
			}
			if (bothValid) {
				msg = jQuery.checkDateRange(lb, ub);
				if (msg.length > 0) {
					errMsg += "Invalid date range for '" + varName + "':" + msg
							+ "\n";
				}
			}
		} else {
			rhs = jQuery("input[name^='dateTerm']", cwr).val();
			if (!jQuery.isValidDate(rhs)) {
				errMsg += "Invalid date value of '" + rhs + "' for " + varName
						+ "!\n";
			}
		}
	}
	return errMsg;
};

qbuilder.QueryBuilder.prototype.buildQP = function(cwr, type) {
	var s = 'operator:', rhs, op, lb, ub;
	if (type == 'integer' || type == 'INT' || type == 'REAL' || type == 'FLOAT') {
		op = jQuery("select[name^='numericMatchType']", cwr).val();
		s += op;
		if (op == 7) {
			lb = jQuery("input[name^='numberRange1']", cwr).val();
			ub = jQuery("input[name^='numberRange2']", cwr).val();
			s += ",lowBound:'" + lb + "', uppBound:'" + ub + "'";
		} else {
			rhs = jQuery("input[name^='term']", cwr).val();
			s += ",rhs:'" + rhs + "'";
		}
	} else if (type == 'varchar' || type == 'STRING') {
		op = jQuery("select[name^='stringMatchType']", cwr).val();
		s += op + ", rhs:'";
		rhs = jQuery("input[name^='term']", cwr).val();
		s += rhs + "'";
	} else if (type == 'BOOL' || type == 'boolean') {
		var c = jQuery(":radio[name^='booleanFilter']:checked", cwr);
		s += "1, rhs:'" + c.val() + "'";
	} else if (type == 'DATE') {
		op = jQuery("select[name^='dateMatchType']", cwr).val();
		s += op;
		if (op == 7) {
			lb = jQuery("input[name^='dateRange1']", cwr).val();
			ub = jQuery("input[name^='dateRange2']", cwr).val();
			s += ",lowBound:'" + lb + "', uppBound:'" + ub + "'";
		} else {
			rhs = jQuery("input[name^='dateTerm']", cwr).val();
			s += ",rhs:'" + rhs + "'";
		}
	}
	return s;
};

qbuilder.QueryBuilder.prototype.buildQuery = function() {
	var filters = jQuery('#searchPane div.filterItem');
	var aqJSON = "asQPIList:[";
	var pqJSON = "jobProvQPIList:[";
	var dqJSON = "jobResultQPIList:[";
	var self = this;
	var aqpCount = 0, pqpCount = 0, dqpCount = 0;
	var partIdx = 0;
	var errMsg = '';
	filters.each(function() {
		var wr = jQuery(this), connective, vgSel$;
		var asSel = jQuery("select[name^='assessment']", wr);
		if (asSel.size() > 0) {
			if (aqpCount > 0)
				aqJSON += ',';
			var asSelOpt = jQuery(':selected', asSel);
			var asId = asSelOpt.val();
			var asName = asSelOpt.text();
			var scoreEl = jQuery("select[name^='score']", wr);
			var score = scoreEl.val();
			var scoreType = jQuery(':selected', scoreEl).data('ctx');
			connective = jQuery('select.connective', wr).val() || 'NONE';
			// alert("asName:" + asName + " asId:" + asId + " score:" + score +
			// " type:" + scoreType);
			aqJSON += "{ asi: { name:'" + asName + "', asId:" + asId
					+ "},score:{ name:'" + score + "',type:'" + scoreType
					+ "'}, connector:'" + connective + "',partIdx:" + partIdx
					+ ",";
			aqJSON += self.buildQP(wr, scoreType);
			errMsg += self.validateQP(wr, scoreType, score);
			aqJSON += '}';
			aqpCount++;
		} else {
			var provSel = jQuery("select[name^='provenance']", wr);
			if (provSel.size() > 0) {
				if (pqpCount > 0)
					pqJSON += ',';
				var provSelOpt = jQuery(":selected", provSel);
				var provName = provSelOpt.val();
				var provType = provSelOpt.data('ctx');
				connective = jQuery('select.connective', wr).val() || 'NONE';
				pqJSON += "{ prov: {name:'" + provName + "', value:''},";
				pqJSON += "provType:'" + provType + "',";
				pqJSON += "connector:'" + connective + "',partIdx:" + partIdx
						+ ",";
				pqJSON += self.buildQP(wr, provType);
				errMsg += self.validateQP(wr, provType, provName);
				pqJSON += '}';
				pqpCount++;
			} else {
				var derivedSel = jQuery("select[name^='derived']", wr);
				if (derivedSel.size() > 0) {
					if (dqpCount > 0)
						dqJSON += ',';
					var jrgName = jQuery(':selected', derivedSel).val();
					vgSel$ = jQuery("select[name^='resultVars']", wr);
					var varName = vgSel$.val();
					vgSel$ = jQuery("select[name^='varGroup']", wr);
					var vgName = vgSel$.val();
					var jrg = jQuery.grep(self.derivedMeta, function(o) {
						return o.name == jrgName;
					})[0];
					var jr = jQuery.grep(jrg.resultTypes, function(o) {
						return o.group == vgName && o.name == varName;
					})[0];
					dqJSON += "{ jrgi: {name:'" + jrgName
							+ "',descr:''}, resultType:{name:'" + jr.name
							+ "',descr:'" + jr.descr + "',unit:'" + jr.unit
							+ "',type:'" + jr.type + "'},";
					connective = jQuery('select.connective', wr).val()
							|| 'NONE';
					dqJSON += "connector:'" + connective + "',partIdx:"
							+ partIdx + ",";
					dqJSON += self.buildQP(wr, jr.type);
					dqJSON += self.validateQP(wr, jr.type, jr.group + ' '
							+ jr.name);
					dqJSON += '}';
					dqpCount++;
				}
			}
		}
		partIdx++;
	});
	aqJSON += ']';
	pqJSON += ']';
	dqJSON += ']';
	var query = '', len = 0, s, selOpts;
	
	if (this.expList !== null) {
		selOpts = jQuery(':selected', jQuery("#searchExpSel"));
		s = 'selExpIds:[';
		len = selOpts.length;
		jQuery.each(selOpts, function(n) {
			s += jQuery(this).val();
			if ((n + 1) < len)
				s += ",";
		});
		s += ']';
		query = "{" + aqJSON + ",\n" + pqJSON + ",\n" + dqJSON + ",\n" + s
				+ "}";
	} else {
		query = "{" + aqJSON + ",\n" + pqJSON + ",\n" + dqJSON + "}";
	}
	if (aqpCount === 0 && pqpCount === 0 && dqpCount === 0) {
		if (this.options && this.options.allowExpOnlyQuery === true) {
		   if (len === 0) {
			   errMsg += "At least an experiment/project needs to be selected!";
		   }  	
		} else {
		   errMsg += "At least one search condition is required!";
		}
	}
	/*
	 * alert("query:" + query); if (errMsg.length > 0) { alert(errMsg); }
	 */
	return {
		"query" : query,
		"errMsg" : errMsg
	};
};
