DROP TABLE nc_assessmentBoolean CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_assessmentBoolean 
--

CREATE TABLE nc_assessmentBoolean(
    tableID                           NUMBER(38, 0)    NOT NULL,
    nc_assessmentData_uniqueID        NUMBER(38, 0)    NOT NULL,
    scoreOrder                        NUMBER(38, 0)    NOT NULL,
    owner                             NUMBER(38, 0)    NOT NULL,
    modTime                           DATE             NOT NULL,
    modUser                           NUMBER(38, 0)    NOT NULL,
    textValue                         VARCHAR2(255),
    textNormValue                     VARCHAR2(255),
    comments                          CLOB,
    dataValue                         NUMBER(1, 0),
    dataNormValue                     NUMBER(1, 0),
    storedAssessmentID                NUMBER(38, 0)    NOT NULL,
    assessmentID                      NUMBER(38, 0)    NOT NULL,
    scoreName                         VARCHAR2(128)    NOT NULL,
    scoreType                         VARCHAR2(64)     NOT NULL,
    isValidated                       NUMBER(1, 0)      DEFAULT 0 NOT NULL,
    isRanked                          NUMBER(1, 0)      DEFAULT 0 NOT NULL,
    subjectID                         VARCHAR2(64)     NOT NULL,
    entryID                           NUMBER(38, 0),
    keyerID                           NUMBER(38, 0),
    raterID                           NUMBER(38, 0),
    classification                    NUMBER(38, 0),
    nc_dataClassification_uniqueID    NUMBER(38, 0),
    uniqueID                          NUMBER(38, 0),
    CONSTRAINT nc_assessmentBoolean_pk PRIMARY KEY (tableID, nc_assessmentData_uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_assessmentBoolean_pidx on nc_assessmentBoolean(tableID, nc_assessmentData_uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_assessmentBoolean_sk  UNIQUE (nc_assessmentData_uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_assessmentBoolean_sidx on nc_assessmentBoolean(nc_assessmentData_uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON TABLE nc_assessmentBoolean IS 'The assessmentBoolean table stores all boolean scores for an assessment.'
;
COMMENT ON COLUMN nc_assessmentBoolean.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_assessmentBoolean.nc_assessmentData_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentBoolean.scoreOrder IS 'The sequenceStep domain is used to represent the stage (or step) in a sequence of events. For example an experimental condition (i.e. nc_expCondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4.
'
;
COMMENT ON COLUMN nc_assessmentBoolean.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentBoolean.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_assessmentBoolean.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentBoolean.textValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentBoolean.textNormValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentBoolean.comments IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_assessmentBoolean.dataValue IS 'The booleanData domain is used to hold native boolean data.'
;
COMMENT ON COLUMN nc_assessmentBoolean.dataNormValue IS 'The booleanData domain is used to hold native boolean data.'
;
COMMENT ON COLUMN nc_assessmentBoolean.storedAssessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentBoolean.assessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentBoolean.scoreName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_assessmentBoolean.scoreType IS 'The type column describes the data type of the object being described by the tuple.'
;
COMMENT ON COLUMN nc_assessmentBoolean.isValidated IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_assessmentBoolean.isRanked IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_assessmentBoolean.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_assessmentBoolean.entryID IS 'The sequenceStep domain is used to represent the stage (or step) in a sequence of events. For example an experimental condition (i.e. nc_expCondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4.
'
;
COMMENT ON COLUMN nc_assessmentBoolean.keyerID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentBoolean.raterID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentBoolean.nc_dataClassification_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentBoolean.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
