DROP TABLE nc_assessmentFloat CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_assessmentFloat 
--

CREATE TABLE nc_assessmentFloat(
    tableID                       NUMBER(38, 0)       NOT NULL,
    nc_assessmentData_uniqueID    NUMBER(38, 0)       NOT NULL,
    scoreOrder                    NUMBER(38, 0)       NOT NULL,
    owner                         NUMBER(38, 0)       NOT NULL,
    modTime                       DATE                NOT NULL,
    modUser                       NUMBER(38, 0)       NOT NULL,
    textValue                     VARCHAR2(255),
    textNormValue                 VARCHAR2(255),
    comments                      CLOB,
    dataValue                     DOUBLE PRECISION,
    dataNormValue                 DOUBLE PRECISION,
    storedAssessmentID            NUMBER(38, 0)       NOT NULL,
    assessmentID                  NUMBER(38, 0)       NOT NULL,
    scoreName                     VARCHAR2(128)       NOT NULL,
    scoreType                     VARCHAR2(64)        NOT NULL,
    isValidated                   NUMBER(1, 0)         DEFAULT 0 NOT NULL,
    isRanked                      NUMBER(1, 0)         DEFAULT 0 NOT NULL,
    subjectID                     VARCHAR2(64)        NOT NULL,
    entryID                       NUMBER(38, 0),
    keyerID                       NUMBER(38, 0),
    raterID                       NUMBER(38, 0),
    classification                NUMBER(38, 0),
    uniqueID                      NUMBER(38, 0),
    CONSTRAINT nc_assessmentFloat_pk PRIMARY KEY (tableID, nc_assessmentData_uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_assessmentFloat_pidx on nc_assessmentFloat(tableID, nc_assessmentData_uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_assessmentFloat_sk  UNIQUE (nc_assessmentData_uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_assessmentFloat_sidx on nc_assessmentFloat(nc_assessmentData_uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_assessmentFloat.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_assessmentFloat.nc_assessmentData_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentFloat.scoreOrder IS 'The sequenceStep domain is used to represent the stage (or step) in a sequence of events. For example an experimental condition (i.e. nc_expCondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4.
'
;
COMMENT ON COLUMN nc_assessmentFloat.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_assessmentFloat.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_assessmentFloat.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_assessmentFloat.textValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentFloat.textNormValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentFloat.comments IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_assessmentFloat.dataValue IS 'The floarData domain is used to hold native double precision or floating point data.'
;
COMMENT ON COLUMN nc_assessmentFloat.dataNormValue IS 'The floarData domain is used to hold native double precision or floating point data.'
;
COMMENT ON COLUMN nc_assessmentFloat.storedAssessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentFloat.assessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentFloat.scoreName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_assessmentFloat.scoreType IS 'The type column describes the data type of the object being described by the tuple.'
;
COMMENT ON COLUMN nc_assessmentFloat.isValidated IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_assessmentFloat.isRanked IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_assessmentFloat.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_assessmentFloat.entryID IS 'The sequenceID domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  The sequence begins with 1.'
;
COMMENT ON COLUMN nc_assessmentFloat.keyerID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentFloat.raterID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentFloat.classification IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentFloat.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
