DROP TABLE nc_assessmentScoreCode CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_assessmentScoreCode 
--

CREATE TABLE nc_assessmentScoreCode(
    assessmentID      NUMBER(38, 0)    NOT NULL,
    scoreName         VARCHAR2(128)    NOT NULL,
    scoreCode         VARCHAR2(128)    NOT NULL,
    scoreCodeLabel    VARCHAR2(255)    NOT NULL,
    tableID           NUMBER(38, 0)    NOT NULL,
    uniqueID          NUMBER(38, 0)    NOT NULL,
    owner             NUMBER(38, 0)    NOT NULL,
    modTime           DATE             NOT NULL,
    modUser           NUMBER(38, 0)    NOT NULL,
    scoreCodeValue    VARCHAR2(255)    NOT NULL,
    scoreCodeType     VARCHAR2(64)     NOT NULL,
    description       CLOB,
    ontologySource    VARCHAR2(128),
    conceptID         VARCHAR2(64),
    CONSTRAINT nc_assessmentScoreCode_pk PRIMARY KEY (assessmentID, scoreName, scoreCode, scoreCodeLabel)
 		USING INDEX
 		(CREATE INDEX nc_assessmentScoreCode_pidx on nc_assessmentScoreCode(assessmentID, scoreName, scoreCode, scoreCodeLabel)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_assessmentScoreCode_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_assessmentScoreCode_sidx on nc_assessmentScoreCode(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_assessmentScoreCode.assessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentScoreCode.scoreName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_assessmentScoreCode.scoreCode IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentScoreCode.scoreCodeLabel IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentScoreCode.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_assessmentScoreCode.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentScoreCode.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_assessmentScoreCode.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_assessmentScoreCode.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_assessmentScoreCode.scoreCodeValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_assessmentScoreCode.scoreCodeType IS 'The type column describes the data type of the object being described by the tuple.'
;
COMMENT ON COLUMN nc_assessmentScoreCode.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_assessmentScoreCode.ontologySource IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_assessmentScoreCode.conceptID IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
