DROP TABLE nc_assessmentStatus CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_assessmentStatus 
--

CREATE TABLE nc_assessmentStatus(
    status         VARCHAR2(64)     NOT NULL,
    tableID        NUMBER(38, 0)    NOT NULL,
    uniqueID       NUMBER(38, 0)    NOT NULL,
    owner          NUMBER(38, 0)    NOT NULL,
    modTime        DATE             NOT NULL,
    modUser        NUMBER(38, 0)    NOT NULL,
    name           VARCHAR2(128)    NOT NULL,
    description    CLOB,
    CONSTRAINT nc_assessmentStatus_pk PRIMARY KEY (status)
 		USING INDEX
 		(CREATE INDEX nc_assessmentStatus_pidx on nc_assessmentStatus(status)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_assessmentStatus_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_assessmentStatus_sidx on nc_assessmentStatus(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_assessmentStatus.status IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_assessmentStatus.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_assessmentStatus.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_assessmentStatus.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_assessmentStatus.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_assessmentStatus.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_assessmentStatus.name IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_assessmentStatus.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
