DROP TABLE nc_databaseUser CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_databaseUser 
--

CREATE TABLE nc_databaseUser(
    uniqueID      NUMBER(38, 0)    NOT NULL,
    name          VARCHAR2(128)    NOT NULL,
    tableID       NUMBER(38, 0)    NOT NULL,
    owner         NUMBER(38, 0)    NOT NULL,
    modTime       DATE             NOT NULL,
    modUser       NUMBER(38, 0)    NOT NULL,
    userClass     NUMBER(38, 0)     DEFAULT 0 NOT NULL,
    userStatus    NUMBER(38, 0)     DEFAULT 0 NOT NULL,
    isGroup       NUMBER(1, 0)     NOT NULL,
    personID      NUMBER(38, 0)    NOT NULL,
    CONSTRAINT nc_databaseUser_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_databaseUser_pidx on nc_databaseUser(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_databaseUser_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_databaseUser_sidx on nc_databaseUser(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_databaseUser.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_databaseUser.name IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_databaseUser.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_databaseUser.owner IS 'The owner column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who owns the data (owner) in a tuple (e.g. the prinicipal investigator of a project who leads the experiment) and who actually entered the data (modUser) in the tuple (e.g. the PI''s graduate student researcher).'
;
COMMENT ON COLUMN nc_databaseUser.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_databaseUser.modUser IS 'The modUser column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the owner column these two columns specify who owns the data (owner) in a tuple (e.g. the prinicipal investigator of a project who leads the experiment) and who actually entered the data (modUser) in the tuple (e.g. the PI''s graduate student researcher).'
;
COMMENT ON COLUMN nc_databaseUser.userClass IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_databaseUser.userStatus IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_databaseUser.isGroup IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_databaseUser.personID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
