DROP TABLE nc_dbColumnUnit CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_dbColumnUnit 
--

CREATE TABLE nc_dbColumnUnit(
    columnTable          NUMBER(38, 0)    NOT NULL,
    columnName           VARCHAR2(200)    NOT NULL,
    measurementSystem    VARCHAR2(128)    NOT NULL,
    unit                 VARCHAR2(64)     NOT NULL,
    uniqueID             NUMBER(38, 0)    NOT NULL,
    tableID              NUMBER(38, 0)    NOT NULL,
    owner                NUMBER(38, 0)    NOT NULL,
    modUser              NUMBER(38, 0)    NOT NULL,
    modTime              DATE             NOT NULL,
    CONSTRAINT nc_dbColumnUnits_pk PRIMARY KEY (columnTable, columnName, measurementSystem, unit)
 		USING INDEX
 		(CREATE INDEX nc_dbColumnUnit_pidx on nc_dbColumnUnit(columnTable, columnName, measurementSystem, unit)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_dbColumnUnits_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_dbColumnUnit_sidx on nc_dbColumnUnit(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON TABLE nc_dbColumnUnit IS 'The nc__dbColumnUnits table is the backing table that links all columns within the database to their default measurement units.'
;
COMMENT ON COLUMN nc_dbColumnUnit.columnTable IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_dbColumnUnit.columnName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_dbColumnUnit.measurementSystem IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_dbColumnUnit.unit IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_dbColumnUnit.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_dbColumnUnit.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_dbColumnUnit.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_dbColumnUnit.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_dbColumnUnit.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
