DROP TABLE nc_expComponent CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_expComponent 
--

CREATE TABLE nc_expComponent(
    componentID               NUMBER(38, 0)       NOT NULL,
    nc_experiment_uniqueID    NUMBER(38, 0)       NOT NULL,
    subjectID                 VARCHAR2(64)        NOT NULL,
    uniqueID                  NUMBER(38, 0)       NOT NULL,
    tableID                   NUMBER(38, 0)       NOT NULL,
    owner                     NUMBER(38, 0)       NOT NULL,
    modTime                   DATE                NOT NULL,
    modUser                   NUMBER(38, 0)       NOT NULL,
    time_stamp                TIMESTAMP(6)        NOT NULL,
    description               CLOB,
    visitType                 VARCHAR2(64)        NOT NULL,
    name                      VARCHAR2(128),
    timeInterval              DOUBLE PRECISION     DEFAULT 0,
    isTimeInterval            NUMBER(1, 0),
    CHECK (componentID > 0),
    CONSTRAINT nc_expComponent_pk PRIMARY KEY (componentID, nc_experiment_uniqueID, subjectID)
 		USING INDEX
 		(CREATE INDEX nc_expComponent_pidx on nc_expComponent(componentID, nc_experiment_uniqueID, subjectID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_expComponent_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_expComponent_sidx on nc_expComponent(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_expComponent.componentID IS 'The sequential identifier for a subject clinical or scanner visit'
;
COMMENT ON COLUMN nc_expComponent.nc_experiment_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expComponent.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_expComponent.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expComponent.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_expComponent.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_expComponent.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_expComponent.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_expComponent.time_stamp IS 'The date and time of the visit.'
;
COMMENT ON COLUMN nc_expComponent.description IS 'Textual description of the visit.'
;
COMMENT ON COLUMN nc_expComponent.visitType IS 'The name of the visit type (e.g. ''clinical'' or ''scan'')'
;
COMMENT ON COLUMN nc_expComponent.name IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_expComponent.isTimeInterval IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
