DROP TABLE nc_expCondition CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_expCondition 
--

CREATE TABLE nc_expCondition(
    expManipulationID    NUMBER(38, 0)    NOT NULL,
    tableID              NUMBER(38, 0)    NOT NULL,
    owner                NUMBER(38, 0)    NOT NULL,
    modTime              DATE             NOT NULL,
    modUser              NUMBER(38, 0)    NOT NULL,
    extensionName        VARCHAR2(128)     DEFAULT 'expCondition' NOT NULL,
    condition            VARCHAR2(128),
    description          CLOB,
    ontologySource       VARCHAR2(128)    NOT NULL,
    conceptID            VARCHAR2(64)     NOT NULL,
    uniqueID             NUMBER(38, 0),
    CONSTRAINT nc_expCondition_pk PRIMARY KEY (expManipulationID)
 		USING INDEX
 		(CREATE INDEX nc_expCondition_pidx on nc_expCondition(expManipulationID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_expCondition_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_expCondition_sidx on nc_expCondition(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_expCondition.expManipulationID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expCondition.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_expCondition.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expCondition.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_expCondition.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expCondition.extensionName IS 'The extensionName column is used in inheritance hierarchies to name the object (i.e. the table) a tuple is associated with.  This should default to the name of the table.'
;
COMMENT ON COLUMN nc_expCondition.condition IS 'The condition column holds the name of the manipulation (i.e. children of nc_expManipulation - nc_expEvent or nc_expCondition). This name should be descriptive if possible.  The condition name will be used in the generation of any stimulus files and analysis files.'
;
COMMENT ON COLUMN nc_expCondition.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_expCondition.ontologySource IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_expCondition.conceptID IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_expCondition.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
