DROP TABLE nc_expManipulation CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_expManipulation 
--

CREATE TABLE nc_expManipulation(
    uniqueID          NUMBER(38, 0)    NOT NULL,
    tableID           NUMBER(38, 0)    NOT NULL,
    owner             NUMBER(38, 0)    NOT NULL,
    modTime           DATE             NOT NULL,
    modUser           NUMBER(38, 0)    NOT NULL,
    extensionName     VARCHAR2(128)     DEFAULT 'expManipulation' NOT NULL,
    ontologySource    VARCHAR2(128)    NOT NULL,
    conceptID         VARCHAR2(64)     NOT NULL,
    CONSTRAINT nc_expManipulation_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_expManipulation_pidx on nc_expManipulation(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_expManipulation_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_expManipulation_sidx on nc_expManipulation(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_expManipulation.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expManipulation.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_expManipulation.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_expManipulation.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_expManipulation.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_expManipulation.extensionName IS 'The extensionName column is used in inheritance hierarchies to name the object (i.e. the table) a tuple is associated with.  This should default to the name of the table.'
;
COMMENT ON COLUMN nc_expManipulation.ontologySource IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_expManipulation.conceptID IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
