DROP TABLE nc_expSegment CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_expSegment 
--

CREATE TABLE nc_expSegment(
    segmentID                 NUMBER(38, 0)       NOT NULL,
    componentID               NUMBER(38, 0)       NOT NULL,
    nc_experiment_uniqueID    NUMBER(38, 0)       NOT NULL,
    subjectID                 VARCHAR2(64)        NOT NULL,
    uniqueID                  NUMBER(38, 0)       NOT NULL,
    tableID                   NUMBER(38, 0)       NOT NULL,
    owner                     NUMBER(38, 0)       NOT NULL,
    modTime                   DATE                NOT NULL,
    modUser                   NUMBER(38, 0)       NOT NULL,
    time_stamp                TIMESTAMP(6)        NOT NULL,
    description               CLOB,
    protocolVersion           NUMBER(38, 0)        DEFAULT 1 NOT NULL,
    protocolID                VARCHAR2(64)        NOT NULL,
    studyID                   NUMBER(38, 0),
    name                      VARCHAR2(128),
    isTimeInterval            NUMBER(1, 0)         DEFAULT 0 NOT NULL,
    timeInterval              DOUBLE PRECISION,
    isBad                     NUMBER(1, 0)         DEFAULT 0 NOT NULL,
    CONSTRAINT nc_expSegment_pk PRIMARY KEY (segmentID, componentID, nc_experiment_uniqueID, subjectID)
 		USING INDEX
 		(CREATE INDEX nc_expSegment_pidx on nc_expSegment(segmentID, componentID, nc_experiment_uniqueID, subjectID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_expSegment_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_expSegment_sidx on nc_expSegment(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_expSegment.segmentID IS 'The sequential ID of the visit segment. For example during a scanning visit each scan would be sequentially numbered.'
;
COMMENT ON COLUMN nc_expSegment.componentID IS 'The sequenceID domain is used to define an ordered sequence of entries or objects (e.g. visits by a subject).  The sequence begins with 1.'
;
COMMENT ON COLUMN nc_expSegment.nc_experiment_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expSegment.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_expSegment.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expSegment.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_expSegment.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_expSegment.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_expSegment.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_expSegment.time_stamp IS 'The timestamp domain is used to notate the date and time of an occurence (e.g. a subject visit, nc_expComponent).  The timestamp refers to the beginning (start) time for the object.'
;
COMMENT ON COLUMN nc_expSegment.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_expSegment.protocolVersion IS 'The versionID domain is used to denote version identifiers. These identifiers can have major and minor revisions.'
;
COMMENT ON COLUMN nc_expSegment.protocolID IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_expSegment.studyID IS 'The sequential ID of the visit segment. For example during a scanning visit each scan would be sequentially numbered.'
;
COMMENT ON COLUMN nc_expSegment.name IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_expSegment.isTimeInterval IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_expSegment.isBad IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
