DROP TABLE nc_humanSubject CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_humanSubject 
--

CREATE TABLE nc_humanSubject(
    subjectID                    VARCHAR2(64)     NOT NULL,
    tableID                      NUMBER(38, 0)    NOT NULL,
    uniqueID                     NUMBER(38, 0)    NOT NULL,
    owner                        NUMBER(38, 0)    NOT NULL,
    modTime                      DATE             NOT NULL,
    modUser                      NUMBER(38, 0)    NOT NULL,
    extensionName                VARCHAR2(128)     DEFAULT 'humanSubject' NOT NULL,
    nc_animalSpecies_uniqueID    NUMBER(38, 0)    NOT NULL,
    localID                      VARCHAR2(64),
    name                         VARCHAR2(128),
    birthdate                    DATE,
    CONSTRAINT nc_humanSubject_pk PRIMARY KEY (subjectID)
 		USING INDEX
 		(CREATE INDEX nc_humanSubject_pidx on nc_humanSubject(subjectID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_humanSubject_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_humanSubject_sidx on nc_humanSubject(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_humanSubject.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_humanSubject.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_humanSubject.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_humanSubject.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_humanSubject.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_humanSubject.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_humanSubject.extensionName IS 'The name of the research subject type.'
;
COMMENT ON COLUMN nc_humanSubject.nc_animalSpecies_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_humanSubject.localID IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_humanSubject.name IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_humanSubject.birthdate IS 'the dateOfBirth column stores the birthdate of a research subject.  '
;
