DROP TABLE nc_measurementSystem CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_measurementSystem 
--

CREATE TABLE nc_measurementSystem(
    name           VARCHAR2(128)    NOT NULL,
    uniqueID       NUMBER(38, 0)    NOT NULL,
    tableID        NUMBER(38, 0)    NOT NULL,
    owner          NUMBER(38, 0)    NOT NULL,
    modTime        DATE             NOT NULL,
    modUser        NUMBER(38, 0)    NOT NULL,
    description    CLOB,
    CONSTRAINT nc_measurementSystem_pk PRIMARY KEY (name)
 		USING INDEX
 		(CREATE INDEX nc_measurementSystem_pidx on nc_measurementSystem(name)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_measurementSystem_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_measurementSystem_sidx on nc_measurementSystem(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_measurementSystem.name IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_measurementSystem.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_measurementSystem.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_measurementSystem.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_measurementSystem.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_measurementSystem.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_measurementSystem.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
