DROP TABLE nc_ontologyConcept CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_ontologyConcept 
--

CREATE TABLE nc_ontologyConcept(
    ontologySource    VARCHAR2(128)     NOT NULL,
    conceptID         VARCHAR2(64)      NOT NULL,
    concept           VARCHAR2(128)     NOT NULL,
    uniqueID          NUMBER(38, 0)     NOT NULL,
    tableID           NUMBER(38, 0)     NOT NULL,
    owner             NUMBER(38, 0)     NOT NULL,
    modTime           DATE              NOT NULL,
    modUser           NUMBER(38, 0)     NOT NULL,
    ontologyPath      VARCHAR2(2048),
    CONSTRAINT nc_ontologyConcept_pk PRIMARY KEY (ontologySource, conceptID)
 		USING INDEX
 		(CREATE INDEX nc_ontologyConcept_pidx on nc_ontologyConcept(ontologySource, conceptID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_ontologyConcept_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_ontologyConcept_sidx on nc_ontologyConcept(uniqueID, tableID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_ontologyTerm_uk_full  UNIQUE (ontologySource, conceptID, concept)
 		USING INDEX
 		(CREATE INDEX nc_ontologyConcept_uidx on nc_ontologyConcept(ontologySource, conceptID, concept)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_ontologyConcept.ontologySource IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_ontologyConcept.conceptID IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_ontologyConcept.concept IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_ontologyConcept.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_ontologyConcept.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_ontologyConcept.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_ontologyConcept.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_ontologyConcept.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_ontologyConcept.ontologyPath IS 'The ontology path is the complete description of the hierarchy (from the root object in a terminological tree) to a specific ontological concept. This can be viewed as similar to a directory path.  Following the UNIX path analogy, the separator for the ontology path shall be a: ''/''. An example of such a path is as follows for the cerebellar Purkinje cell: /Brain/Cerebellum/Cerebellar Cortex/Purkinje Cell. It is important to note that hierarchies are dependent on the source ontology.  '
;
