DROP TABLE nc_ontologySource CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_ontologySource 
--

CREATE TABLE nc_ontologySource(
    ontologySource    VARCHAR2(128)     NOT NULL,
    uniqueID          NUMBER(38, 0)     NOT NULL,
    tableID           NUMBER(38, 0)     NOT NULL,
    owner             NUMBER(38, 0)     NOT NULL,
    modTime           DATE              NOT NULL,
    modUser           NUMBER(38, 0)     NOT NULL,
    sourceURI         VARCHAR2(2048),
    description       CLOB,
    CONSTRAINT nc_ontologySource_pk PRIMARY KEY (ontologySource)
 		USING INDEX
 		(CREATE INDEX nc_ontologySource_pidx on nc_ontologySource(ontologySource)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_ontologySource_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_ontologySource_sidx on nc_ontologySource(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_ontologySource.ontologySource IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_ontologySource.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_ontologySource.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_ontologySource.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_ontologySource.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_ontologySource.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_ontologySource.sourceURI IS 'The URI column references the object being described by the tuple.  For data objects, for example, The URI can reference either an individual object (e.g. file or document) or an entire collection (e.g. directory of DICOM images).  

A Uniform Resource Identifier (URI) is a compact sequence of characters that identifies an abstract or physical resource.  The standard for URIs can be found at: http://www.ietf.org/rfc/rfc3986.txt'
;
COMMENT ON COLUMN nc_ontologySource.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
