DROP TABLE nc_protocolManip CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_protocolManip 
--

CREATE TABLE nc_protocolManip(
    uniqueID                       NUMBER(38, 0)    NOT NULL,
    tableID                        NUMBER(38, 0)    NOT NULL,
    owner                          NUMBER(38, 0)    NOT NULL,
    modTime                        DATE             NOT NULL,
    modUser                        NUMBER(38, 0)    NOT NULL,
    type                           VARCHAR2(18),
    start_value                    NUMBER(38, 0)     DEFAULT 1 NOT NULL,
    end_value                      NUMBER(38, 0)     DEFAULT 1 NOT NULL,
    protocolVersion                NUMBER(38, 0)     DEFAULT 1 NOT NULL,
    protocolID                     VARCHAR2(64)     NOT NULL,
    nc_expManipulation_uniqueID    NUMBER(38, 0)    NOT NULL,
    CONSTRAINT nc_protocolManip_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_protocolManip_pidx on nc_protocolManip(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_protocolManip_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_protocolManip_sidx on nc_protocolManip(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_protocolManip.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_protocolManip.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_protocolManip.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_protocolManip.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_protocolManip.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_protocolManip.start_value IS 'The sequenceStep domain is used to represent the stage (or step) in a sequence of events. For example an experimental condition (i.e. nc_expCondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4.
'
;
COMMENT ON COLUMN nc_protocolManip.end_value IS 'The sequenceStep domain is used to represent the stage (or step) in a sequence of events. For example an experimental condition (i.e. nc_expCondition) that starts on the second segment and finishes on the fourth would have a start value of 2 and an end value of 4.
'
;
COMMENT ON COLUMN nc_protocolManip.protocolVersion IS 'The versionID domain is used to denote version identifiers. These identifiers can have major and minor revisions.'
;
COMMENT ON COLUMN nc_protocolManip.protocolID IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_protocolManip.nc_expManipulation_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
