DROP TABLE nc_researchData CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_researchData 
--

CREATE TABLE nc_researchData(
    uniqueID         NUMBER(38, 0)     NOT NULL,
    tableID          NUMBER(38, 0)     NOT NULL,
    owner            NUMBER(38, 0)     NOT NULL,
    modTime          DATE              NOT NULL,
    modUser          NUMBER(38, 0)     NOT NULL,
    extensionName    VARCHAR2(128)      DEFAULT 'researchData' NOT NULL,
    dataURI          VARCHAR2(2048),
    isRaw            NUMBER(1, 0)      NOT NULL,
    dataOntology     VARCHAR2(128)     NOT NULL,
    dataClass        VARCHAR2(64)      NOT NULL,
    isBad            NUMBER(1, 0)       DEFAULT 0 NOT NULL,
    CONSTRAINT nc_researchData_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_researchData_pidx on nc_researchData(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_researchData_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_researchData_sidx on nc_researchData(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_researchData.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_researchData.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_researchData.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_researchData.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_researchData.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_researchData.extensionName IS 'The extensionName column is used in inheritance hierarchies to name the object (i.e. the table) a tuple is associated with.  This should default to the name of the table.'
;
COMMENT ON COLUMN nc_researchData.dataURI IS 'The URI for the selected data (can be multiple files or just a single file)'
;
COMMENT ON COLUMN nc_researchData.isRaw IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_researchData.dataOntology IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_researchData.dataClass IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_researchData.isBad IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
