DROP TABLE nc_scoreValidator CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_scoreValidator 
--

CREATE TABLE nc_scoreValidator(
    uniqueID          NUMBER(38, 0)    NOT NULL,
    tableID           NUMBER(38, 0)    NOT NULL,
    owner             NUMBER(38, 0)    NOT NULL,
    modTime           DATE             NOT NULL,
    modUser           NUMBER(38, 0)    NOT NULL,
    assessmentID      NUMBER(38, 0),
    scoreName         VARCHAR2(128),
    validatorTable    NUMBER(38, 0)    NOT NULL,
    validatorID       NUMBER(38, 0)    NOT NULL,
    CONSTRAINT nc_scoreValidator_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_scoreValidator_pidx on nc_scoreValidator(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_scoreValidator_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_scoreValidator_sidx on nc_scoreValidator(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_scoreValidator.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_scoreValidator.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_scoreValidator.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_scoreValidator.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_scoreValidator.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_scoreValidator.assessmentID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_scoreValidator.scoreName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_scoreValidator.validatorTable IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_scoreValidator.validatorID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
