DROP TABLE nc_storedQuery CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_storedQuery 
--

CREATE TABLE nc_storedQuery(
    uniqueID       NUMBER(38, 0)    NOT NULL,
    tableID        NUMBER(38, 0)    NOT NULL,
    owner          NUMBER(38, 0)    NOT NULL,
    modTime        DATE             NOT NULL,
    modUser        NUMBER(38, 0)    NOT NULL,
    userName       VARCHAR2(128)    NOT NULL,
    queryState     CLOB             NOT NULL,
    description    VARCHAR2(255),
    CONSTRAINT nc_storedQuery_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_storedQuery_pidx on nc_storedQuery(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_storedQuery_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_storedQuery_sidx on nc_storedQuery(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_storedQuery.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_storedQuery.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_storedQuery.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_storedQuery.modTime IS 'The modTimecolumn is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who entered the data (modUser) and when (modTime).  Taken together with a core table (nc_TABLENAME) and its backing table (bk_TABLENAME which is used to store the history of changes to a tuple) modTime allows one to fully recreate the history of every tuple stored in a core table.'
;
COMMENT ON COLUMN nc_storedQuery.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_storedQuery.queryState IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_storedQuery.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
