DROP TABLE nc_subjExperiment CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_subjExperiment 
--

CREATE TABLE nc_subjExperiment(
    uniqueID                     NUMBER(38, 0)    NOT NULL,
    tableID                      NUMBER(38, 0)    NOT NULL,
    owner                        NUMBER(38, 0)    NOT NULL,
    modTime                      DATE             NOT NULL,
    modUser                      NUMBER(38, 0)    NOT NULL,
    nc_experiment_uniqueID       NUMBER(38, 0)    NOT NULL,
    subjectID                    VARCHAR2(64)     NOT NULL,
    nc_researchGroup_uniqueID    NUMBER(38, 0)    NOT NULL,
    CONSTRAINT nc_subjExperiment_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_subjExperiment_pidx on nc_subjExperiment(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_subjExperiment_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_subjExperiment_sidx on nc_subjExperiment(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_subjExperiment.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_subjExperiment.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_subjExperiment.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_subjExperiment.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_subjExperiment.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_subjExperiment.nc_experiment_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_subjExperiment.subjectID IS 'The investigator ID for the research subject.'
;
COMMENT ON COLUMN nc_subjExperiment.nc_researchGroup_uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
