DROP TABLE nc_tupleSubClass CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_tupleSubClass 
--

CREATE TABLE nc_tupleSubClass(
    tupleSubClass    VARCHAR2(128)    NOT NULL,
    tupleClass       VARCHAR2(128)    NOT NULL,
    uniqueID         NUMBER(38, 0)    NOT NULL,
    tableID          NUMBER(38, 0)    NOT NULL,
    owner            NUMBER(38, 0)    NOT NULL,
    modTime          DATE             NOT NULL,
    modUser          NUMBER(38, 0)    NOT NULL,
    CONSTRAINT nc_tupleSubClass_pk PRIMARY KEY (tupleSubClass, tupleClass)
 		USING INDEX
 		(CREATE INDEX nc_tupleSubClass_pidx on nc_tupleSubClass(tupleSubClass, tupleClass)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_tupleSubClass_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_tupleSubClass_sidx on nc_tupleSubClass(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_tupleSubClass.tupleSubClass IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_tupleSubClass.tupleClass IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_tupleSubClass.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_tupleSubClass.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_tupleSubClass.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_tupleSubClass.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_tupleSubClass.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
