DROP TABLE nc_updateLog CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_updateLog 
--

CREATE TABLE nc_updateLog(
    uniqueID    NUMBER(38, 0)    NOT NULL,
    tableID     NUMBER(38, 0)    NOT NULL,
    modTime     DATE             NOT NULL,
    modUser     NUMBER(38, 0)    NOT NULL,
    owner       NUMBER(38, 0),
    comments    CLOB,
    CONSTRAINT nc_updateLog_pk PRIMARY KEY (uniqueID, tableID, modTime)
 		USING INDEX
 		(CREATE INDEX nc_updateLog_pidx on nc_updateLog(uniqueID, tableID, modTime)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_updateLog.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_updateLog.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_updateLog.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_updateLog.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_updateLog.owner IS 'The owner column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the modUser column these two columns specify who owns the data (owner) in a tuple (e.g. the prinicipal investigator of a project who leads the experiment) and who actually entered the data (modUser) in the tuple (e.g. the PI''s graduate student researcher).'
;
COMMENT ON COLUMN nc_updateLog.comments IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
