DROP TABLE nc_usedLibrary CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_usedLibrary 
--

CREATE TABLE nc_usedLibrary(
    libraryID              NUMBER(38, 0)    NOT NULL,
    executedTransformID    NUMBER(38, 0)    NOT NULL,
    uniqueID               NUMBER(38, 0)    NOT NULL,
    tableID                NUMBER(38, 0)    NOT NULL,
    owner                  NUMBER(38, 0)    NOT NULL,
    modTime                DATE             NOT NULL,
    modUser                NUMBER(38, 0)    NOT NULL,
    CONSTRAINT nc_usedLibrary_pk PRIMARY KEY (libraryID, executedTransformID)
 		USING INDEX
 		(CREATE INDEX nc_usedLibrary_pidx on nc_usedLibrary(libraryID, executedTransformID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_usedLibrary_sk  UNIQUE (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_usedLibrary_sidx on nc_usedLibrary(uniqueID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_usedLibrary.libraryID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_usedLibrary.executedTransformID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_usedLibrary.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_usedLibrary.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_usedLibrary.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_usedLibrary.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_usedLibrary.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
