-- 
-- TRIGGER: nc_assessmentVarchar_ins_upd 
--

-- BEGIN PL/SQL BLOCK (do not remove this line) -------------------------------- 
create or replace trigger nc_assessmentVarchar_ins_upd 
 BEFORE INSERT or UPDATE ON nc_assessmentVarchar 
FOR EACH ROW 
begin 
     :new.uniqueID := :new.nc_assessmentData_uniqueID; 
End; 
 
-- END PL/SQL BLOCK (do not remove this line) ---------------------------------- 
/ 

create or replace trigger nc_assessmentVarchar_insert
 AFTER INSERT ON NC_ASSESSMENTVARCHAR
 FOR EACH ROW
begin
  INSERT INTO NC_ASSESSMENTDATA
    (TABLEID,UNIQUEID,SCOREORDER, OWNER,MODTIME,MODUSER,ASSESSMENTID,
     SCORENAME, SCORETYPE, TEXTVALUE, TEXTNORMVALUE,
     ENCRYPTED, COMMENTS,NC_STOREDASSESSMENT_UNIQUEID,SUBJECTID,
     ISVALIDATED, ISRANKED, ENTRYID, KEYERID, RATERID, CLASSIFICATION)
  VALUES(:new.TABLEID,
        :new.NC_ASSESSMENTDATA_UNIQUEID,
        :new.SCOREORDER,
        :new.OWNER,
        :new.MODTIME,
        :new.MODUSER,
        :new.ASSESSMENTID,
        :new.SCORENAME,
        :new.SCORETYPE,
        :new.TEXTVALUE,
        :new.TEXTNORMVALUE,
        0,
        :new.COMMENTS,
        :new.STOREDASSESSMENTID,
        :new.SUBJECTID,
        :new.ISVALIDATED,
        :new.ISRANKED,
        :new.ENTRYID,
        :new.KEYERID, 
        :new.RATERID, 
        :new.CLASSIFICATION);
end;
/

create or replace trigger nc_assessmentVarchar_update
 AFTER UPDATE ON NC_ASSESSMENTVARCHAR
 FOR EACH ROW
begin
    UPDATE NC_ASSESSMENTDATA
    SET OWNER = :new.OWNER,
        MODTIME = :new.MODTIME,
        MODUSER = :new.MODUSER,
        ASSESSMENTID = :new.ASSESSMENTID,
        SCORENAME = :new.SCORENAME,
        SCORETYPE = :new.SCORETYPE,
        TEXTVALUE = :new.TEXTVALUE,
        TEXTNORMVALUE = :new.TEXTNORMVALUE,
        COMMENTS = :new.COMMENTS,
        NC_STOREDASSESSMENT_UNIQUEID = :new.STOREDASSESSMENTID,
        SUBJECTID = :new.SUBJECTID,
        ISVALIDATED = :new.ISVALIDATED,
        ISRANKED = :new.ISRANKED,
        ENTRYID = :new.ENTRYID,
        KEYERID = :new.KEYERID, 
        RATERID = :new.RATERID, 
        CLASSIFICATION = :new.CLASSIFICATION
  WHERE
     TABLEID = :new.TABLEID AND UNIQUEID = :new.NC_ASSESSMENTDATA_UNIQUEID
     AND SCOREORDER = :new.SCOREORDER;

end;
/

-- delete trigger

create or replace trigger nc_assessmentVarchar_delete
 AFTER DELETE ON NC_ASSESSMENTVARCHAR
 FOR EACH ROW
begin
 DELETE FROM NC_ASSESSMENTDATA
 WHERE
   TABLEID = :old.TABLEID AND UNIQUEID = :old.NC_ASSESSMENTDATA_UNIQUEID
     AND SCOREORDER = :old.SCOREORDER;

end;
/

