-- select create_rater('fbirn_test', 'Burak', 'Ozyurt', 'iozyurt@ucsd.edu', 525);

create or replace function create_rater(varchar, varchar, varchar, varchar, numeric) returns integer as '
declare
  rater_name_in alias for $1;
  first_name_in alias for $2; 
  last_name_in alias for $3;
  email_in alias for $4;
  owner_id_in alias for $5;
  du_cur cursor for select uniqueid from nc_databaseuser where
     name = rater_name_in and
     userclass=(select uniqueid from nc_userclass where name=''researcher'');
  rater_id numeric := -1;
  person_id numeric := -1;
begin
   person_id := get_person_id(first_name_in, last_name_in, email_in) ;
   raise notice ''first name:% last_name:% email:%'', first_name_in, last_name_in, email_in;
   raise notice ''create rater person_id:%'', person_id;

 if person_id < 0 then
   person_id := nextval(''uid_seq'');
   insert into nc_person (uniqueid,tableid,owner,
        modtime,moduser,first_name, last_name, email)
     values(person_id, get_table_id(''nc_person''), owner_id_in,
       now(), owner_id_in, first_name_in,
        last_name_in, email_in);
 end if;
 open du_cur;
 loop
   fetch du_cur into rater_id;
   if rater_id is NULL then
     rater_id := -1;
     exit;
   end if;
 end loop;
 close du_cur;
 if rater_id = -1 then
   rater_id :=  nextval(''uid_seq'');
   insert into nc_databaseUser ( uniqueid,name,tableid,
            owner, modtime, moduser, userclass,userstatus,
            isgroup, personid)
     values(rater_id,
            UPPER(rater_name_in),
            get_table_id(''nc_databaseuser''), owner_id_in,
             now(), owner_id_in,
            (select uniqueid from nc_userclass where name=''researcher''),
            (select uniqueid from nc_userstatus where userstatus=''active''),
             false,
             person_id);
 end if;
 return 0;

END;
' LANGUAGE plpgsql;
