create or replace function create_static_data(varchar, varchar, varchar, varchar) returns integer as '
DECLARE
   database_user_name_in ALIAS for $1;
   first_name_in ALIAS for $2;
   last_name_in alias for $3;
   email_in alias for $4;

  v_owner_id integer := -1;
  v_mod_user_id integer := -1;
  v_table_id integer;
  v_MAJORVERSION integer := 1;
  v_MINORVERSION integer := 0;
  v_count integer;
BEGIN

-- NC_TABLEID
insert into NC_TABLEID (TABLENAME,TABLEID,OWNER,MODTIME,MODUSER,MAJORVERSION,MINORVERSION,DESCRIPTION,UNIQUEID)
   select tablename, nextval(''uid_seq''), -1, now(), -1, v_MAJORVERSION, v_MINORVERSION, NULL, -1 from pg_tables where tablename like ''nc__%'' or tablename like ''bk__%'';

-- nc_userClass
insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''researcher'',''researcher'',''researcher'');

insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''data processing'',''data processing'',''data processing'');

insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''admin'',''admin'',''admin'');

insert into nc_userClass(UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERCLASS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userClass''), v_owner_id, now(), v_owner_id, ''data manager'',''data manager'',''data manager'');

-- nc_userStatus
insert into nc_userStatus (UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERSTATUS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''active'', ''active'', ''active'');

insert into nc_userStatus (UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERSTATUS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''inactive'', ''inactive'', ''inactive'');

insert into nc_userStatus (UNIQUEID, TABLEID, OWNER, MODTIME, MODUSER, USERSTATUS,NAME,DESCRIPTION)
values(nextval(''uid_seq''), get_table_id(''nc_userStatus''), v_owner_id, now(), v_owner_id, ''revoked'', ''revoked'', ''revoked'');


   v_owner_id := create_birn_user(database_user_name_in, database_user_name_in, 
   first_name_in, last_name_in, email_in, database_user_name_in, ''admin'', -1);

if v_owner_id < 0 then
   raise exception "error in create_birn_user!";
end if;

return -1;

END;
' LANGUAGE plpgsql;
